---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-Progress.ADS
--  Description : GUI Widget Progress bar
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with mcc.tki.Colors;
with mcc.tki.Container;
with mcc.tki.Widget.Text_Entry;

package gui.Widget.Progress is

   type Progress is new GUI_Widget with record
      Color : mcc.tki.Colors.FG_BG_Color;
   end record;

   -- reads information from file into Progress,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Progress);

   -- Writes information to file from Progress
   procedure Write_Widget (Widget : in Progress);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Progress);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Progress);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Progress;
      Window_Name : in String);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Progress;
      Container : in out mcc.tki.Container.Container'Class);

   procedure Set_Properties (Widget : in out Progress);

   procedure Apply_Properties (Widget : in out Progress);
   procedure Check_Properties (Widget : in out Progress; Ok : out Boolean);

end Gui.Widget.Progress;
