------------------------------------------------------------------------------
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
-- Auto generated by RAPID
-- Copyright (C) 2003, Martin C. Carlisle and W. Blair Watkinson II

with Subwindow_Actions;
with Toolbar;
with File_Menu;
with Edit_Menu;
with Tools_Menu;
with Help_Menu;

with mcc.tki.Fonts;

package body main_window is

   procedure Generate_Window is
   begin

      if mcc.tki.Container.Window.Is_Open
           (mcc.tki.Container.Window.Window (main_window))
      then
         raise Already_Open;
      end if;

      mcc.tki.Container.Window.Create
        (Obj    => main_window,
         X      => 0,
         Y      => 0,
         Width  => 356,  -- 312
         Height => 117);

      mcc.tki.Container.Window.Set_Title
        (Obj   => main_window,
         Title => "RAPID");

      mcc.tki.Menu.Create (Obj => main_Menu, Window => main_window);

      mcc.tki.Menu.Add_Submenu
        (Obj         => File_SubMenu,
         Text        => "File",
         Underline   => 1,
         Parent_Menu => main_Menu);
      mcc.tki.Menu.Add_Choice
        (Obj         => New_Choice,
         To_Menu     => File_SubMenu,
         Text        => "New",
         Action      => File_Menu.New_Choice'Access,
         Underline   => 1,
         Accelerator => "Ctrl+N");
      mcc.tki.Menu.Add_Choice
        (Obj         => Open_Choice,
         To_Menu     => File_SubMenu,
         Text        => "Open",
         Action      => File_Menu.Open_Choice'Access,
         Underline   => 1,
         Accelerator => "Ctrl+O");
      mcc.tki.Menu.Add_Choice
        (Obj         => Close_Choice,
         To_Menu     => File_SubMenu,
         Text        => "Close",
         Action      => File_Menu.Close_Choice'Access,
         Underline   => 1,
         Accelerator => "Ctrl+F4");
      mcc.tki.Menu.Add_Choice
        (Obj         => Save_Choice,
         To_Menu     => File_SubMenu,
         Text        => "Save",
         Action      => File_Menu.Save_Choice'Access,
         Underline   => 1,
         Accelerator => "Ctrl+S");
      mcc.tki.Menu.Add_Choice
        (Obj         => Save_As_Choice,
         To_Menu     => File_SubMenu,
         Text        => "Save As",
         Action      => File_Menu.SaveAs_Choice'Access,
         Underline   => 6,
         Accelerator => "");
      mcc.tki.Menu.Add_Choice
        (Obj         => Exit_Choice,
         To_Menu     => File_SubMenu,
         Text        => "Exit",
         Action      => File_Menu.Exit_Choice'Access,
         Underline   => 2,
         Accelerator => "");
      mcc.tki.Menu.Add_Submenu
        (Obj         => Edit_SubMenu,
         Text        => "Edit",
         Underline   => 1,
         Parent_Menu => main_Menu);
      mcc.tki.Menu.Add_Choice
        (Obj         => Modify_Window_Choice,
         To_Menu     => Edit_SubMenu,
         Text        => "Modify Window",
         Action      => Edit_Menu.Change_Window'Access,
         Underline   => 1,
         Accelerator => "");
      mcc.tki.Menu.Add_Choice
        (Obj         => Delete_Choice,
         To_Menu     => Edit_SubMenu,
         Text        => "Delete",
         Action      => Edit_Menu.Delete_Choice'Access,
         Underline   => 3,
         Accelerator => "Del");
      mcc.tki.Menu.Add_Choice
        (Obj         => Duplicate_Choice,
         To_Menu     => Edit_SubMenu,
         Text        => "Duplicate",
         Action      => Edit_Menu.Duplicate_Choice'Access,
         Underline   => 3,
         Accelerator => "Ctrl+D");
      mcc.tki.Menu.Add_Submenu
        (Obj         => Tools_SubMenu,
         Text        => "Tools",
         Underline   => 1,
         Parent_Menu => main_Menu);
      mcc.tki.Menu.Add_Choice
        (Obj         => Compile_Choice,
         To_Menu     => Tools_SubMenu,
         Text        => "Compile",
         Action      => Tools_Menu.Compile_Choice'Access,
         Underline   => 1,
         Accelerator => "Ctrl+M");
      mcc.tki.Menu.Add_Submenu
        (Obj         => Help_SubMenu,
         Text        => "Help",
         Underline   => 1,
         Parent_Menu => main_Menu);
      mcc.tki.Menu.Add_Choice
        (Obj         => About_Choice,
         To_Menu     => Help_SubMenu,
         Text        => "About",
         Action      => Help_Menu.About'Access,
         Underline   => 1,
         Accelerator => "");

      mcc.tki.Image.Create (Obj => new_gif_gif_Image, Name => "new_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => newButton,
         Parent => main_window,
         X      => 0,
         Y      => 0,
         Width  => 27,
         Height => 27,
         Image  => new_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => newButton,
         Text => "New");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => newButton'Access,
         Callback => File_Menu.New_Choice'Access);
      mcc.tki.Image.Create
        (Obj  => open_gif_gif_Image,
         Name => "open_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => openButton,
         Parent => main_window,
         X      => 27,
         Y      => 0,
         Width  => 27,
         Height => 27,
         Image  => open_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => openButton,
         Text => "Open");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => openButton'Access,
         Callback => File_Menu.Open_Choice'Access);
      mcc.tki.Image.Create
        (Obj  => save_gif_gif_Image,
         Name => "save_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => saveButton,
         Parent => main_window,
         X      => 54,
         Y      => 0,
         Width  => 27,
         Height => 27,
         Image  => save_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => saveButton,
         Text => "Save");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => saveButton'Access,
         Callback => File_Menu.Save_Choice'Access);
      mcc.tki.Image.Create
        (Obj  => menu_gif_gif_Image,
         Name => "menu_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => menubutton,
         Parent => main_window,
         X      => 91,
         Y      => 0,
         Width  => 27,
         Height => 27,
         Image  => menu_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => menubutton,
         Text => "Edit menus");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => menubutton'Access,
         Callback => Subwindow_Actions.Edit_Menu'Access);
      mcc.tki.Image.Create (Obj => cut_gif_gif_Image, Name => "cut_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => cutButton,
         Parent => main_window,
         X      => 128,
         Y      => 0,
         Width  => 27,
         Height => 27,
         Image  => cut_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => cutButton,
         Text => "Cut");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => cutButton'Access,
         Callback => Edit_Menu.Delete_Choice'Access);
      mcc.tki.Image.Create
        (Obj  => copy_gif_gif_Image,
         Name => "copy_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => duplicatebutton,
         Parent => main_window,
         X      => 155,
         Y      => 0,
         Width  => 27,
         Height => 27,
         Image  => copy_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => duplicatebutton,
         Text => "Duplicate");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => duplicatebutton'Access,
         Callback => Edit_Menu.Duplicate_Choice'Access);
      mcc.tki.Image.Create
        (Obj  => compile_gif_gif_Image,
         Name => "compile_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => compileButton,
         Parent => main_window,
         X      => 182,
         Y      => 0,
         Width  => 27,
         Height => 27,
         Image  => compile_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => compileButton,
         Text => "Compile");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => compileButton'Access,
         Callback => Tools_Menu.Compile_Choice'Access);
      mcc.tki.Image.Create
        (Obj  => label_gif_gif_Image,
         Name => "label_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => labelButton,
         Parent => main_window,
         X      => 0,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => label_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => labelButton,
         Text => "Text label");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => labelButton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => text_button_gif_gif_Image,
         Name => "text_button_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => textBButton,
         Parent => main_window,
         X      => 27,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => text_button_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => textBButton,
         Text => "Text button");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => textBButton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => picture_button_gif_gif_Image,
         Name => "picture_button_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => pictureBButton,
         Parent => main_window,
         X      => 54,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => picture_button_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => pictureBButton,
         Text => "Picture button");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => pictureBButton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => text_entry_gif_gif_Image,
         Name => "text_entry_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => textEntryButton,
         Parent => main_window,
         X      => 81,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => text_entry_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => textEntryButton,
         Text => "Text entry");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => textEntryButton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => check_gif_gif_Image,
         Name => "check_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => check_button,
         Parent => main_window,
         X      => 108,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => check_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => check_button,
         Text => "Check button");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => check_button'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => radio_button_gif_gif_Image,
         Name => "radio_button_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => radio_button,
         Parent => main_window,
         X      => 135,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => radio_button_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => radio_button,
         Text => "Radio button");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => radio_button'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => picture_gif_gif_Image,
         Name => "picture_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => picture_select,
         Parent => main_window,
         X      => 162,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => picture_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => picture_select,
         Text => "Picture");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => picture_select'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => listbox_gif_gif_Image,
         Name => "listbox_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => listboxButton,
         Parent => main_window,
         X      => 189,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => listbox_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => listboxButton,
         Text => "Listbox");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => listboxButton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => scale_button_gif_gif_Image,
         Name => "scale_button_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => scaleButton,
         Parent => main_window,
         X      => 216,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => scale_button_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => scaleButton,
         Text => "Scale slider");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => scaleButton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => progress_button_gif_gif_Image,
         Name => "progress_button_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => progressbutton,
         Parent => main_window,
         X      => 243,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => progress_button_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => progressbutton,
         Text => "Progress bar");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => progressbutton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => dropdown_button_gif_gif_Image,
         Name => "dropdown_button_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => dropdownbutton,
         Parent => main_window,
         X      => 270,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => dropdown_button_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => dropdownbutton,
         Text => "Dropdown list");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => dropdownbutton'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => textbox_gif_gif_Image,
         Name => "textbox_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => textbox_button,
         Parent => main_window,
         X      => 297,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => textbox_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => textbox_button,
         Text => "Textbox");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => textbox_button'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Image.Create
        (Obj  => Frame_gif_gif_Image,
         Name => "frame_gif.gif");
      mcc.tki.Widget.Button.Picture.Create
        (Obj    => Frame_Button,
         Parent => main_window,
         X      => 324,
         Y      => 29,
         Width  => 27,
         Height => 27,
         Image  => Frame_gif_gif_Image);
      mcc.tki.Widget.Button.Picture.Set_Tooltip_Text
        (Obj  => Frame_Button,
         Text => "Frame");
      mcc.tki.Widget.Button.Set_Push_Callback
        (Obj      => Frame_Button'Access,
         Callback => Toolbar.Select_Widget'Access);
      mcc.tki.Widget.Label.Create
        (Obj     => name,
         Parent  => main_window,
         X       => 0,
         Y       => 59,
         Width   => 180,
         Height  => 23,
         Justify => mcc.tki.Widget.Label.Left,
         Text    => "No Window Open");
      mcc.tki.Widget.Label.Set_Foreground_Color
        (Obj       => name,
         New_Color => mcc.tki.Colors.Named_Color (mcc.tki.Colors.Black));

   end Generate_Window;

   procedure Fill_Window is
   begin
      null; -- in case there aren't any widgets to fill

   end Fill_Window;

   procedure Generate_and_Fill_Window is
   begin
      Generate_Window;
      Fill_Window;
   end Generate_and_Fill_Window;

   procedure Read_Window
     (Success         : out Boolean;
      Highlight_Error : in Boolean := True;
      Beep_On_Error   : in Boolean := True)
   is
   begin
      Success := True;
   exception
      when others =>
         Success := False;
         if Beep_On_Error then
            mcc.tki.Bell;
         end if;
   end Read_Window;

   procedure Close_Window is
   begin
      mcc.tki.Destroy (mcc.tki.Object (main_window));
   end Close_Window;

end main_window;
