-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           TCL PEER FOR THE MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Tcl;
with Tcl.Ada;
with Ada.Unchecked_Deallocation;
package peer is
   -- Everything in Tcl/Tk is string based, so a peer is just the
   -- name of the Tk widget.
   type String_Pointer is access all String;
   procedure Free_String is new Ada.Unchecked_Deallocation (
      Object => String,
      Name => String_Pointer);

   -- Name is the Tcl/Tk name of the object
   -- Lookup is the index into the expanding array
   -- where the object is stored
   type Peer is record
      Name   : String_Pointer;
      Lookup : Natural := 0;
   end record;

   --------------------------------------------------------
   -- function Create_Peer
   --
   -- returns a new toplevel name
   --------------------------------------------------------
   function Create_Peer return Peer;

   --------------------------------------------------------
   -- function Create_Peer
   --
   -- returns a new name that is a descendant of Parent
   --------------------------------------------------------
   function Create_Peer (Parent : in Peer) return Peer;

   -------------------------
   -- Eval
   --
   -- calls Tcl.Ada.Tcl_Eval
   -------------------------
   procedure Eval (Expression : in String);

   ---------------------------------------------------
   -- Get_Interp
   --
   -- returns Interp, initializing if needed
   ---------------------------------------------------
   function Get_Interp return  Tcl.Tcl_Interp;

   --------------------------------------------------
   -- To_Hex_String
   --
   -- converts a number to a Hexadecimal string
   --------------------------------------------------
   function To_Hex_String
     (Number : in Natural;
      Width  : in Natural := 6)
      return   String;

   -- used to create callbacks
   package CreateCommands is new Tcl.Ada.Generic_Command (Integer);

   -- returns a string where \ is replaced by \\ and
   -- " is replaced by \"
   function Fix_Quotes (Text : in String) return String;

   -- basically the inverse of Fix_Quotes
   function Unescape (Text : in String) return String;

   -- return name with "." converted to "_", remove 1st '.'
   function Undot_Name (Name : in String) return String;

   -- return the value of a Tcl variable as a string
   procedure Get_Value
     (Name   : in String;
      Result : out String;
      Last   : out Natural);

   -- return the value of a Tcl variable as an integer
   procedure Get_Value (Name : in String; Result : out Integer);

end peer;
