#  Copyright (C) 2005-2010, Axis Communications AB, LUND, SWEDEN
#
#  This file is part of RAPP.
#
#  RAPP is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  You can use the comments under either the terms of the GNU Lesser General
#  Public License version 3 as published by the Free Software Foundation,
#  either version 3 of the License or (at your option) any later version, or
#  the GNU Free Documentation License version 1.3 or any later version
#  published by the Free Software Foundation; with no Invariant Sections, no
#  Front-Cover Texts, and no Back-Cover Texts.
#  A copy of the license is included in the documentation section entitled
#  "GNU Free Documentation License".
#
#  RAPP is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License and a copy of the GNU Free Documentation License along
#  with RAPP. If not, see <http://www.gnu.org/licenses/>.


####################################################################
#  Configuration file for the structuring elements of the built-in
#  binary morphology primitives.
####################################################################

selist = [ \
    # Horizontal line
    {'name': 'line_1x2',
     'desc': '1x2 filled horizontal line.',
     'hit': [[-1,0], [0,0]]},
    {'name': 'line_1x3',
     'desc': '1x3 filled horizontal line.',
     'hit': [[-1,0], [0,0], [1,0]]},
    {'name': 'line_1x3_p',
     'desc': '1x3 horizontal line perimeter.',
     'hit': [[-1,0], [1,0]]},
    {'name': 'line_1x5_p',
     'desc': '1x5 horizontal line perimeter',
     'hit': [[-2,0], [2,0]]},
    {'name': 'line_1x7_p',
     'desc': '1x7 horizontal line perimeter',
     'hit': [[-3,0], [3,0]]},
    {'name': 'line_1x9_p',
     'desc': '1x7 horizontal line perimeter',
     'hit': [[-4,0], [4,0]]},
    {'name': 'line_1x13_p',
     'desc': ' 1x13 horizontal line perimeter',
     'hit': [[-6,0], [6,0]]},
    {'name': 'line_1x15_p',
     'desc': '1x15 horizontal line perimeter',
     'hit': [[-7,0], [7,0]]},
    {'name': 'line_1x17_p',
     'desc': '1x17 horizontal line perimeter',
     'hit': [[-8,0], [8,0]]},
    {'name': 'line_1x25_p',
     'desc': '1x25 horizontal line perimeter',
     'hit': [[-12,0], [12,0]]},
    {'name': 'line_1x29_p',
     'desc': '1x29 horizontal line perimeter',
     'hit': [[-14,0], [14,0]]},
    {'name': 'line_1x31_p',
     'desc': '1x31 horizontal line perimeter',
     'hit': [[-15,0], [15,0]]},
    # Vertical line
    {'name': 'line_2x1',
     'desc': '2x1 filled vertical line.',
     'hit': [[0,-1], [0,0]]},
    {'name': 'line_3x1',
     'desc': '3x1 filled vertical line.',
     'hit': [[0,-1], [0,0], [0,1]]},
    {'name': 'line_3x1_p',
     'desc': '3x1 vertical line perimeter.',
     'hit': [[0,-1], [0,1]]},
    {'name': 'line_5x1_p',
     'desc': '5x1 vertical line perimeter',
     'hit': [[0,-2], [0,2]]},
    {'name': 'line_7x1_p',
     'desc': '7x1 vertical line perimeter',
     'hit': [[0,-3], [0,3]]},
    {'name': 'line_9x1_p',
     'desc': '9x1 vertical line perimeter',
     'hit': [[0,-4], [0,4]]},
    {'name': 'line_13x1_p',
     'desc': '13x1 vertical line perimeter',
     'hit': [[0,-6], [0,6]]},
    {'name': 'line_15x1_p',
     'desc': '15x1 vertical line perimeter',
     'hit': [[0,-7], [0,7]]},
    {'name': 'line_17x1_p',
     'desc': '17x1 vertical line perimeter',
     'hit': [[0,-8], [0,8]]},
    {'name': 'line_25x1_p',
     'desc': '25x1 vertical line perimeter',
     'hit': [[0,-12], [0,12]]},
    {'name': 'line_29x1_p',
     'desc':' 29x1 vertical line perimeter',
     'hit': [[0,-14], [0,14]]},
    {'name': 'line_31x1_p',
     'desc': '31x1 vertical line perimeter',
     'hit': [[0,-15], [0,15]]},
    # Square
    {'name': 'square_2x2',
     'desc': '2x2 filled square.',
     'hit': [[-1,-1], [0,-1],
             [-1, 0], [0, 0]]},
    {'name': 'square_3x3',
     'desc': '3x3 filled square.',
     'hit': [[-1,-1], [0,-1], [1,-1],
             [-1, 0], [0, 0], [1, 0],
             [-1, 1], [0, 1], [1, 1]]},
    {'name': 'square_3x3_p',
     'desc': '3x3 square perimeter.',
     'hit': [[-1,-1], [1,-1],
             [-1, 1], [1, 1]]},
    # Diamond
    {'name': 'diamond_3x3',
     'desc': '3x3 filled diamond.',
     'hit': [[0, -1], [-1, 0], [0, 0], [1, 0], [0, 1]]},
    {'name': 'diamond_3x3_p',
     'desc': '3x3 diamond perimeter.',
     'hit': [[0, -1], [-1, 0], [1, 0], [0, 1]]},
    {'name': 'diamond_5x5_p',
     'desc': '5x5 diamond perimeter.',
     'hit': [[0, -2], [-2, 0], [2, 0], [0, 2]]},
    {'name': 'diamond_7x7_p',
     'desc': '7x7 diamond perimeter.',
     'hit': [[0, -3], [-3, 0], [3, 0], [0, 3]]},
    {'name': 'diamond_9x9_p',
     'desc': '9x9 diamond perimeter.',
     'hit': [[0, -4], [-4, 0], [4, 0], [0, 4]]},
    {'name': 'diamond_13x13_p',
     'desc': '13x13 diamond perimeter.',
     'hit': [[0, -6], [-6, 0], [6, 0], [0, 6]]},
    {'name': 'diamond_15x15_p',
     'desc': '15x15 diamond perimeter.',
     'hit': [[0, -7], [-7, 0], [7, 0], [0, 7]]},
    {'name': 'diamond_17x17_p',
     'desc': '17x17 diamond perimeter.',
     'hit': [[0, -8], [-8, 0], [8, 0], [0, 8]]},
    {'name': 'diamond_25x25_p',
     'desc': '25x25 diamond perimeter.',
     'hit': [[0, -12], [-12, 0], [12, 0], [0, 12]]},
    {'name': 'diamond_29x29_p',
     'desc': '29x29 diamond perimeter.',
     'hit': [[0, -14], [-14, 0], [14, 0], [0, 14]]},
    {'name': 'diamond_31x31_p',
     'desc': '31x31 diamond perimeter.',
     'hit': [[0, -15], [-15, 0], [15, 0], [0, 15]]},
    # Octagon
    {'name': 'octagon_5x5_p',
     'desc': '5x5 octagon perimeter.',
     'hit': [[-1,-2], [1, -2],
             [-2,-1], [2, -1],
             [-2, 1], [2,  1],
             [-1, 2], [1,  2]]},
    {'name': 'octagon_7x7_p',
     'desc': '7x7 octagon perimeter.',
     'hit': [[-1,-3], [1, -3],
             [-3,-1], [3, -1],
             [-3, 1], [3,  1],
             [-1, 3], [1,  3]]},
    {'name': 'octagon_9x9_p',
     'desc': '9x9 octagon perimeter.',
     'hit': [[-2,-4], [2, -4],
             [-4,-2], [4, -2],
             [-4, 2], [4,  2],
             [-2, 4], [2,  4]]},
    {'name': 'octagon_13x13_p',
     'desc': '13x13 octagon perimeter.',
     'hit': [[-2,-6], [2, -6],
             [-6,-2], [6, -2],
             [-6, 2], [6,  2],
             [-2, 6], [2,  6]]},
    {'name': 'octagon_15x15_p',
     'desc': '15x15 octagon perimeter.',
     'hit': [[-3,-7], [3, -7],
             [-7,-3], [7, -3],
             [-7, 3], [7,  3],
             [-3, 7], [3,  7]]},
    {'name': 'octagon_17x17_p',
     'desc': '17x17 octagon perimeter.',
     'hit': [[-3,-8], [3, -8],
             [-8,-3], [8, -3],
             [-8, 3], [8,  3],
             [-3, 8], [3,  8]]},
    {'name': 'octagon_25x25_p',
     'desc': '25x25 octagon perimeter.',
     'hit': [[-5,-12], [5, -12],
             [-12,-5], [12, -5],
             [-12, 5], [12,  5],
             [-5, 12], [5,  12]]},
    {'name': 'octagon_29x29_p',
     'desc': '29x29 octagon perimeter.',
     'hit': [[-6,-14], [6, -14],
             [-14,-6], [14, -6],
             [-14, 6], [14,  6],
             [-6, 14], [6,  14]]},
    {'name': 'octagon_31x31_p',
     'desc': '31x31 octagon perimeter.',
     'hit': [[-6,-15], [6, -15],
             [-15,-6], [15, -6],
             [-15, 6], [15,  6],
             [-6, 15], [6,  15]]},
    # Disc
    {'name': 'disc_7x7',
     'desc': '7x7 filled disc.',
     'hit': [[ 0,-3], [-2,-2], [-1,-2], [ 0,-2], [ 1,-2], [ 2,-2],
             [-2,-1], [-1,-1], [ 0,-1], [ 1,-1], [ 2,-1], [-3, 0],
             [-2, 0], [-1, 0], [ 0, 0], [ 1, 0], [ 2, 0], [ 3, 0],
             [-2, 1], [-1, 1], [ 0, 1], [ 1, 1], [ 2, 1], [-2, 2],
             [-1, 2], [ 0, 2], [ 1, 2], [ 2, 2], [ 0, 3]]},
    {'name': 'disc_7x7_p',
     'desc': '7x7 disc perimeter.',
     'hit': [[ 0,-3], [-2,-2], [ 2,-2],
             [-3, 0], [ 0, 0], [ 3, 0],
             [-2, 2], [ 2, 2], [ 0, 3]]},
    {'name': 'disc_9x9_p',
     'desc': '9x9 disc perimeter.',
     'hit': [[ 0,-4], [-3,-3], [ 3,-3], [-4, 0],
             [ 4, 0], [-3, 3], [ 3, 3], [ 0, 4]]},
    {'name': 'disc_11x11_p',
     'desc': '11x11 disc perimeter.',
     'hit': [[ 0,-5], [-4,-4], [-3,-4], [ 3,-4],
             [ 4,-4], [-4,-3], [ 4,-3], [-5, 0],
             [ 5, 0], [-4, 3], [ 4, 3], [-4, 4],
             [-3, 4], [ 3, 4], [ 4, 4], [ 0, 5]]},
    {'name': 'disc_13x13_p',
     'desc': '13x13 disc perimeter.',
     'hit': [[ 0,-6], [-4,-5], [-3,-5], [ 3,-5], [ 4,-5], [-5,-4], [ 5,-4],
             [-5,-3], [ 5,-3], [-6, 0], [ 0, 0], [ 6, 0], [-5, 3], [ 5, 3],
             [-5, 4], [ 5, 4], [-4, 5], [-3, 5], [ 3, 5], [ 4, 5], [ 0, 6]]},
    {'name': 'disc_15x15_p',
     'desc': '15x15 disc perimeter.',
     'hit': [[ 0,-7], [-4,-6], [-3,-6], [ 3,-6], [ 4,-6],
             [-6,-4], [ 6,-4], [-6,-3], [ 6,-3], [-7, 0],
             [ 7, 0], [-6, 3], [ 6, 3], [-6, 4], [ 6, 4],
             [-4, 6], [-3, 6], [ 3, 6], [ 4, 6], [ 0, 7]]},
    {'name': 'disc_17x17_p',
     'desc': '17x17 disc perimeter.',
     'hit': [[ 0,-8], [-5,-7], [-4,-7], [ 4,-7], [ 5,-7],
             [-7,-5], [ 7,-5], [-7,-4], [ 7,-4], [-8, 0],
             [ 8, 0], [-7, 4], [ 7, 4], [-7, 5], [ 7, 5],
             [-5, 7], [-4, 7], [ 4, 7], [ 5, 7], [ 0, 8]]},
    {'name': 'disc_19x19_p',
     'desc': '19x19 disc perimeter.',
     'hit': [[ 0,-9], [-5,-8], [-4,-8], [ 4,-8], [ 5,-8],
             [-8,-5], [ 8,-5], [-8,-4], [ 8,-4], [-9, 0],
             [ 9, 0], [-8, 4], [ 8, 4], [-8, 5], [ 8, 5],
             [-5, 8], [-4, 8], [ 4, 8], [ 5, 8], [ 0, 9]]},
    {'name': 'disc_25x25_p',
     'desc': '25x25 disc perimeter.',
     'hit': [[ 0,-12], [-6,-11], [-5,-11], [ 5,-11], [ 6,-11],
             [-7,-10], [ 7,-10], [-10,-7], [ 10,-7], [-11,-6],
             [ 11,-6], [-11,-5], [ 11,-5], [-12, 0], [ 12, 0],
             [-11, 5], [ 11, 5], [-11, 6], [ 11, 6], [-10, 7],
             [ 10, 7], [-7, 10], [ 7, 10], [-6, 11], [-5, 11],
             [ 5, 11], [ 6, 11], [ 0, 12]]},
    # Golay letter L, lattice-aligned, 4- and 8-connectivity
    {'name': 'golay_l_3x3_c48_r0',
     'desc': '3x3 HMT Golay letter L, 4- and 8-connectivity, 0 degrees.',
     'hit' : [[-1,  1], [0,  1], [1,  1]],
     'miss': [[-1, -1], [0, -1], [1, -1]]},
    {'name': 'golay_l_3x3_c48_r90',
     'desc': '3x3 HMT Golay letter L, 4- and 8-connectivity, 90 degrees.',
     'hit' : [[-1,  1], [0,  1], [1,  1]],
     'miss': [[-1, -1], [0, -1], [1, -1]],
     'rot' : 1},
    {'name': 'golay_l_3x3_c48_r180',
     'desc': '3x3 HMT Golay letter L, 4- and 8-connectivity, 180 degrees.',
     'hit' : [[-1,  1], [0,  1], [1,  1]],
     'miss': [[-1, -1], [0, -1], [1, -1]],
     'rot' : 2},
    {'name': 'golay_l_3x3_c48_r270',
     'desc': '3x3 HMT Golay letter L, 4- and 8-connectivity, 270 degrees.',
     'hit' : [[-1,  1], [0,  1], [1,  1]],
     'miss': [[-1, -1], [0, -1], [1, -1]],
     'rot' : 3},
    # Golay letter L, slanted, 4-connectivity
    {'name': 'golay_l_3x3_c4_r45',
     'desc': '3x3 HMT Golay letter L, 4-connectivity, 45 degrees.',
     'hit' : [[-1,  0], [-1, 1], [0, 1]],
     'miss': [[ 0, -1], [ 1, 0]]},
    {'name': 'golay_l_3x3_c4_r135',
     'desc': '3x3 HMT Golay letter L, 4-connectivity, 135 degrees.',
     'hit' : [[-1,  0], [-1, 1], [0, 1]],
     'miss': [[ 0, -1], [ 1, 0]],
     'rot' : 1},
    {'name': 'golay_l_3x3_c4_r225',
     'desc': '3x3 HMT Golay letter L, 4-connectivity, 225 degrees.',
     'hit' : [[-1,  0], [-1, 1], [0, 1]],
     'miss': [[ 0, -1], [ 1, 0]],
     'rot' : 2},
    {'name': 'golay_l_3x3_c4_r315',
     'desc': '3x3 HMT Golay letter L, 4-connectivity, 315 degrees.',
     'hit' : [[-1,  0], [-1, 1], [0, 1]],
     'miss': [[ 0, -1], [ 1, 0]],
     'rot' : 3},
    # Golay letter L, slanted, 8-connectivity
    {'name': 'golay_l_3x3_c8_r45',
     'desc': '3x3 HMT Golay letter L, 8-connectivity, 45 degrees.',
     'hit' : [[-1,  0], [0,  1]],
     'miss': [[ 0, -1], [1, -1], [1, 0]]},
    {'name': 'golay_l_3x3_c8_r135',
     'desc': '3x3 HMT Golay letter L, 8-connectivity, 135 degrees.',
     'hit' : [[-1,  0], [0,  1]],
     'miss': [[ 0, -1], [1, -1], [1, 0]],
     'rot' : 1},
    {'name': 'golay_l_3x3_c8_r225',
     'desc': '3x3 HMT Golay letter L, 8-connectivity, 225 degrees.',
     'hit' : [[-1,  0], [0,  1]],
     'miss': [[ 0, -1], [1, -1], [1, 0]],
     'rot' : 2},
    {'name': 'golay_l_3x3_c8_r315',
     'desc': '3x3 HMT Golay letter L, 8-connectivity, 315 degrees.',
     'hit' : [[-1,  0], [0,  1]],
     'miss': [[ 0, -1], [1, -1], [1, 0]],
     'rot' : 3},
    # Golay letter E, lattice-aligned, 4-connectivity
    {'name': 'golay_e_3x3_c4_r0',
     'desc': '3x3 HMT Golay letter E, 4-connectivity, 0 degrees.',
     'miss': [[0, -1], [-1, 0], [1, 0]]},
    {'name': 'golay_e_3x3_c4_r90',
     'desc': '3x3 HMT Golay letter E, 4-connectivity, 90 degrees.',
     'miss': [[0, -1], [-1, 0], [1, 0]],
     'rot' : 1},
    {'name': 'golay_e_3x3_c4_r180',
     'desc': '3x3 HMT Golay letter E, 4-connectivity, 180 degrees.',
     'miss': [[0, -1], [-1, 0], [1, 0]],
     'rot' : 2},
    {'name': 'golay_e_3x3_c4_r270',
     'desc': '3x3 HMT Golay letter E, 4-connectivity, 270 degrees.',
     'miss': [[0, -1], [-1, 0], [1, 0]],
     'rot' : 3},
    # Golay letter E, lattice-aligned, 8-connectivity
    {'name': 'golay_e_3x3_c8_r0',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 0 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],          [1,  0],
              [-1,  1]]},
    {'name': 'golay_e_3x3_c8_r90',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 90 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],          [1,  0],
              [-1,  1]],
     'rot' : 1},
    {'name': 'golay_e_3x3_c8_r180',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 180 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],          [1,  0],
              [-1,  1]],
     'rot' : 2},
    {'name': 'golay_e_3x3_c8_r270',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 270 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],          [1,  0],
              [-1,  1]],
     'rot' : 3},
    # Golay letter E, slanted, 8-connectivity
    {'name': 'golay_e_3x3_c8_r45',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 45 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],
              [-1,  1], [0,  1]]},
    {'name': 'golay_e_3x3_c8_r135',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 135 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],
              [-1,  1], [0,  1]],
     'rot' : 1},
    {'name': 'golay_e_3x3_c8_r225',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 225 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],
              [-1,  1], [0,  1]],
     'rot' : 2},
    {'name': 'golay_e_3x3_c8_r315',
     'desc': '3x3 HMT Golay letter E, 8-connectivity, 315 degrees.',
     'miss': [[-1, -1], [0, -1], [1, -1],
              [-1,  0],
              [-1,  1], [0,  1]],
     'rot' : 3}]
