/* Standard header for ratpoison.
 *  
 * Copyright (C) 2000 Shawn Betts
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA */

#ifndef _RATPOISON_H
#define _RATPOISON_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>
#include <stdio.h>

/* Some error reporting macros */
#define PRE_PRINT_LOCATION fprintf (stderr, "%s:%s():%d: ", __FILE__, __FUNCTION__, __LINE__);
#define PRINT_ERROR(format, args...) \
        { fprintf (stderr, PACKAGE ":error -- "); PRE_PRINT_LOCATION; fprintf (stderr, format, ## args); }

/* Some debugging macros */
#ifdef DEBUG
#  define PRINT_DEBUG(format, args...) \
          { fprintf (stderr, PACKAGE ":debug -- "); PRE_PRINT_LOCATION; fprintf (stderr, format, ## args); }
#else
#  define PRINT_DEBUG(format, args...) 
#endif /* DEBUG */

#include "conf.h"

#include "data.h"
#include "manage.h"
#include "list.h"
#include "bar.h"
#include "events.h"
#include "number.h"
#include "input.h"

void clean_up ();
screen_info *find_screen (Window w);

#endif /* _RATPOISON_H */
