/* functions for managing the window list 
 * Copyright (C) 2000, 2001 Shawn Betts
 *
 * This file is part of ratpoison.
 *
 * ratpoison is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * ratpoison is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 */

#ifndef _RATPOISON_LIST_H
#define _RATPOISON_LIST_H 1

rp_window *add_to_window_list (screen_info *s, Window w);
void init_window_list ();
/* void next_window (); */
/* void prev_window (); */
void last_window ();
rp_window *find_window_in_list (Window w, rp_window *sentinel);
rp_window *find_window (Window w);
void maximize_current_window ();
void set_active_window (rp_window *rp_w);
void set_current_window (rp_window *win);
/* int goto_window_name (char *name); */
rp_window *find_window_other ();
rp_window *find_window_by_number (int n);
rp_window* find_window_name (char *name);
rp_window* find_window_prev (rp_window *w);
rp_window* find_window_next (rp_window *w);
rp_window* find_window_number (int n);
void sort_window_list_by_number ();

void append_to_list (rp_window *win, rp_window *sentinel);
void insert_into_list (rp_window *win, rp_window *sentinel);
void remove_from_list (rp_window *win);

#endif /* ! _RATPOISON_LIST_H */
