#!/usr/bin/perl

#   Rebot 0.10 (beta): Bot para aventuras de texto por red
#   http://aventuras.presi.org/rebot
#   (C) 2005-2007 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License 
#   along with this program.  If not, see <http://www.gnu.org/licenses/>. 

# Rebot kernel

BEGIN
{
use File::Spec;

push(@INC,'modules');
push(@INC,File::Spec->catfile('modules','com'));
push(@INC,File::Spec->catfile('modules','multi'));
push(@INC,'config');
push(@INC,'localization');
}

use FileHandle;
use File::Which;
use Encode;
use rebot_conf;
use functions;

BEGIN
{
no utf8;                    # Inicializando parmetros de configuracin
$d_prefix=$rebot_conf::run_dir_prefix;
$d_tmp=File::Spec->catfile($d_prefix,$rebot_conf::dir_temp);
$d_interprete=File::Spec->catfile($d_prefix,$rebot_conf::dir_interpr);
$d_aventura=File::Spec->catfile($d_prefix,$rebot_conf::dir_adventures);
$d_aplic=File::Spec->catfile($d_prefix,$rebot_conf::dir_applications);
$pref_no_com=!$rebot_conf::prefix_comments;
@prefixes=@rebot_conf::prefixes_comments;
$prefs=' '.join(' ',@prefixes);
$log=$rebot_conf::mod_log;
eval "require $log";                # Incluyendo mdulo de log
$con=$rebot_conf::mod_com;
eval "require $con";                # Incluyendo mdulo de comunicacin
$mod_lang="rebot_lang_$rebot_conf::language";
eval "require $mod_lang";           # Incluyendo mdulo de lenguaje
$multi=$rebot_conf::multi;
if (($multim=$rebot_conf::multi_module) ne '')
{
  eval "require $multim";   # Incluyendo mdulo de multijugador (si es necesario)
}
else { $multi=0; }
undef $/;
}


$modo_comando=1;
$linea1_texto_inicial="Rebot 0.10 (beta): $MSG_bot_descr http://aventuras.presi.org/rebot";
if ($pref_no_com) { $pre_help=' '.$prefixes[0]; }
             else { $pre_help=' '; }
$texto_inicial=$linea1_texto_inicial."\n".$MSG_see_help.$pre_help.$MSG_see_help2;
if ($multi) { $texto_inicial.="\n**$MSG_mosi ($multim)**"; }

sub cargar
{
  $aventura=$_[0];
  $interprete=$_[1];
  my $donde=$_[2];
  my $cand_interprete;

  if ($interprete eq '-aplic-')  # Comprobando si la aplicacin existe
  {
    if (!esta_en_directorio($d_aplic,$aventura,$MSG_ap_no_enc,$donde)) { return 0; }
    $encod=$rebot_conf::app_encoding;
  }
  else  # Comprobando si la aventura existen
  {
    if (!esta_en_directorio($d_aventura,$aventura,$MSG_av_no_enc,$donde)) { return 0; }
    foreach my $aux (@rebot_conf::extensions_interpr)
    {                                          # Buscando intrprete para la aventura
      my ($ext,$int,$opc,$enco)=@$aux;
      if ($aventura=~/\.$ext/i) { $cand_interprete=$int; $opciones=$opc; $encod=$enco; }
    }
    if ($interprete eq '') { $interprete=$cand_interprete; } # si no hay intrprete se asigna

    if ( ($cand_interprete ne $interprete) && $rebot_conf::strict_int )
    {
      $log->eslog("'$interprete': $MSG_int_no_ad '$aventura'",5);
      $con->enviar_mensaje($MSG_int_no_ad,$donde);
      modo('',$donde);
      return 0;
    }
        # Comprobando si el intrprete existe
    if (!esta_en_directorio($d_interprete,$interprete,$MSG_int_no_enc,$donde)) { return 0; }
  }
  # Lanzando aventura o aplicacin

  my $linea;
  my $mens; my $mensl; my $mensi; my $mensf;

  my $bin_perl=which('perl');                           # Preparando lnea de
  $tmp_file=File::Spec->catfile($d_tmp,"tmp$$");     # ejecucin y mensajes
  $err_file=File::Spec->catfile($d_tmp,"err$$");

  if ($interprete eq '-aplic-')                   # para aplicaciones
  {
    my $app_path=File::Spec->catfile($d_aplic,$aventura);
    $linea="$bin_perl la.pl $$ $tmp_file $err_file $app_path";
    $mens="$MSG_ap '$aventura' $MSG_ap_carg1";
    $mensl=$MSG_ap_carg2;
    $mensi=$MSG_lap;
    $mensf=$MSG_ap_end;
  }
  else                                            # para aventuras
  {
    my $interprete_path=File::Spec->catfile($d_interprete,$interprete);
    my $aventura_path=File::Spec->catfile($d_aventura,$aventura);
    $linea="$bin_perl la.pl $$ $tmp_file $err_file $interprete_path $opciones $aventura_path";
    $mens="$MSG_av '$aventura' $MSG_av_carg1 '$interprete'";
    $mensl=$MSG_av_carg2;
    $mensi=$MSG_lav;
    $mensf=$MSG_av_end;
  }
  $log->eslog($linea,3);  
  open(ESINT," | $linea") or die "$MSG_err_lanz $mensi";
  ESINT->autoflush(1);
  sleep $rebot_conf::la_delay;
  open(ERR,$err_file) or die $MSG_err_tmp;
  my $er=<ERR>;
  close(ERR);
  if ($er ne '')
  {
    $log->eslog($er,3);
    $log->eslog("$mensf $MSG_err",5);
    $con->enviar_mensaje("$MSG_err_lanz $mensi",$donde);
    modo('',$donde);
    close(ESINT);
    borr_tmp();
  }
  else
  {
    open(LEINT,$tmp_file) or die $MSG_err_tmp;
    LEINT->autoflush(1);
    my $le=<LEINT>;
    $le=decode($encod,$le);             # convirtiendo la codificacin de caracteres
    my @lel=split("\n",$le);
    if ($lel[@lel-1] =~ m/$xml_end/)            # se comprueba si el intrprete se aborta
    {
      $log->eslog($le,3);
      $log->eslog("$mensf $MSG_err",5);
      $con->enviar_mensaje("$MSG_err_lanz $mensi",$donde);
      modo('comando',$donde);
      close(ESINT);
      close(LEINT);
      borr_tmp();
    }
    else
    {
      $log->eslog($mensl,4);
      $con->enviar_mensaje($mens,$donde);
      modo('juego',$donde);
      $con->enviar_mensaje($le,$donde);      # se vuelca la respuesta

      if ($multi)
      {
        my $texto=$multim->init_adv($le);        # Inicializacin de adventura multijugador
        if ($texto) { print ESINT $texto,"\n"; } # texto inicial que le pasa el mdulo al intrprete
      }
    }
  }
}

sub leer_dir   # Lee un directorio y lo coloca en un array
{
  my $dir=$_[0];
  my @lista_sp;

  opendir(DIR,$dir) or die $MSG_err_dir;
  my @lista=readdir(DIR);
  closedir(DIR);
  foreach my $aux (@lista)
  { if (!(substr($aux,0,1) eq '.')) { push(@lista_sp,$aux); } }
  return @lista_sp;
}

sub listar_dir  # Lee, ordena y lista un directorio
{
  my $dir=$_[0];
  my $donde=$_[1];

  my @lista=sort(leer_dir($dir));
  $con->enviar_mensaje(join("\n",@lista),$donde);
}

sub esta_en_directorio
{
  my $dir=$_[0];
  my $fich=$_[1];
  my $mens_no_enc=$_[2];
  my $donde=$_[3];

  my @lista=leer_dir($dir);
  if (!functions::esta_en($fich,\@lista))  # Comprobando si el fichero est en el directorio
  {
    $log->eslog("'$fich': $mens_no_enc",5);
    $con->enviar_mensaje($mens_no_enc,$donde);
    modo('',$donde);
    return 0;
  }
  return 1;
}

sub ayuda
{
  my $donde=$_[0];
  my $tcom;

  if ($pref_no_com) { $tcom=$MSG_help_nc.$prefs }
               else { $tcom=$MSG_help_c.$prefs.' '.$MSG_help_c2; }

  my $texto_ayuda=$MSG_help."\n".$con->texto_ayuda()."\n".$tcom."\n".$MSG_help2;

  $con->enviar_mensaje($texto_ayuda,$donde);
}

sub multi_init
{
  $multi=1;
  $multim->init();
  $log->eslog("$MSG_mosi ($multim)",2);
  $con->enviar_mensaje("$MSG_mosi ($multim)",$donde);  
}

sub multi_close
{
  $multi=0;
  $multim->close();
  $log->eslog($MSG_mono,2);
  $con->enviar_mensaje($MSG_mono,$donde);
}

sub tratar_texto    # Maneja el texto de entrada
{
   my $texto=$_[0];
   my $donde=$_[1];
   $prefijo_comando=$_[2];

   if (no_comentario($texto) || $prefijo_comando)
   {
     if ($pref_no_com && !$prefijo_comando) { $texto=substr($texto,1); }  # eliminamos el prefijo de no comentario si hace falta

     if ($modo_comando || $prefijo_comando)  # Parser de comandos
     {
        my @elem=split(' ',$texto);
        lc($elem[0]);
        $elem[0]=functions::elimac($elem[0]);
        if ( ($elem[0] eq $COM_cargar) || ($elem[0] eq $COM_jugar) )
        {
           if ($prefijo_comando)
           {
             $log->eslog($MSG_ncprel,4);
             $con->enviar_mensaje($MSG_ncpre,$donde);
             modo('',$donde);
           }
           else { cargar($elem[1],$elem[2],$donde); }
        }
        elsif ( ($elem[0] eq $COM_aventuras) || ($elem[0] eq $COM_juegos) )
        {
           listar_dir($d_aventura,$donde);
           modo('',$donde);
        }
        elsif ( $elem[0] eq $COM_interpretes )
        {
           listar_dir($d_interprete,$donde);
           modo('',$donde);
        }
        elsif ( $elem[0] eq $COM_ejecutar)
        {
           if ($prefijo_comando)
           {
             $log->eslog($MSG_ncprel,4);
             $con->enviar_mensaje($MSG_ncpre,$donde);
             modo('',$donde);
           }
           else { cargar($elem[1],'-aplic-',$donde); }
        }
        elsif ( $elem[0] eq $COM_aplicaciones)
        {
           listar_dir($d_aplic,$donde);
           modo('',$donde);
        }
        elsif ( ($elem[0] eq $COM_ayuda) || ( $elem[0] eq $COM_interrogante) )
        {
           ayuda($donde);
           modo('',$donde);
        }
        elsif ( ($elem[0] eq $COM_cambio) || ($elem[0] eq $COM_cambiar) )
        {
           if ($pref_no_com)
           {
             $pref_no_com=0;
             $log->eslog($MSG_com.$prefs,2);
             $con->enviar_mensaje($MSG_come.$prefs,$donde);
           }
           else
           {
             $pref_no_com=1;
             $log->eslog($MSG_com_no.$prefs,2);
             $con->enviar_mensaje($MSG_coma.$prefs,$donde);
           }
           modo('',$donde);
        }
        elsif ($elem[0] eq $COM_multi)
        {
           if ($elem[1])
           {
             if (!$multi) { multi_init(); }
             if ($multim->args($elem[1])) { $log->eslog("$MSG_args $elem[1]",2); }
             else { $con->enviar_mensaje($MSG_noargs,$donde); }
           }
           else
           {
             if ($multi) { multi_close(); }
             else { multi_init(); }
           }
           modo('',$donde);
        }
        elsif ( !($con->comando($donde,@elem)) )
            { $con->enviar_mensaje($MSG_no_com,$donde); modo('',$donde); }
     }
     else  # modo juego, se le pasa a la aplicacin a menos que vaya con prefijo de comando
     {
        if (substr($texto,0,2) eq $rebot_conf::com_prefix) { tratar_texto(substr($texto,2),$donde,1); }
        else
        {
          $texto=encode($encod,$texto); # convirtiendo la codificacin de caracteres

          if ($multi)
          {
            if ($donde eq '') { return; }             # Se ignora la entrada pblica (desde un canal, no privado)
            $texto=$multim->filtro_in($texto,$donde);   # Filtro de entrada para multijugador
          }                                                         # jugador->aventura

          print ESINT $texto,"\n";  # se le pasa al intrprete
          sleep $rebot_conf::ap_delay;
          $le=<LEINT>;         # primera respuesta del intrprete
          if ($le eq '')       # si es vaca obtener una segunda
             { $le=<LEINT>; }
          $le=decode($encod,$le);     # convirtiendo la codificacin de caracteres
          my @lel=split("\n",$le);
          if ($lel[@lel-1] =~ m/$xml_end/) # se comprueba si ha acabado el interprete
          {
            $log->eslog($MSG_av_end,4);

            if ($multi) { $multim->close_adv(); }  # Se termina la aventura multijugador

            close(ESINT);
            close(LEINT);
            borr_tmp();
            modo('comando',$donde);
          }
          elsif ($multi)
          {
            local $publico;         # Filtro de salida para multijugador, envia a cada jugador su texto

            my %texto_mult=$multim->filtro_out($le,*publico);
            foreach my $user (keys(%texto_mult)) { $con->enviar_mensaje($texto_mult{$user},$user); }
            $con->enviar_mensaje($publico);
          }

          else { $con->enviar_mensaje($le,$donde); }      # se vuelca la respuesta en modo no multi
        }
     }
   }
}


sub modo   # Cambio/consulta de modo (comando o juego)
{
  my $cad_modo=$_[0];
  my $donde=$_[1];

  if ($cad_modo eq '')
  {
    print_modo($modo_comando,$donde,0);
  }
  elsif ($cad_modo eq 'comando')
  {
    $modo_comando=1;
    print_modo(1,$donde,1);
  }
  elsif ($cad_modo eq 'juego')
  {
    $modo_comando=0;
    print_modo(0,$donde,1);
  }
  else { $log->eslog($MSG_mod_err,1); }
}

sub print_modo
{
  my $modo=$_[0];
  my $donde=$_[1];
  my $loggear=$_[2];

  if ($modo)
  {
    if ($loggear) { $log->eslog($MSG_mod_com,2); }
    $con->enviar_mensaje("--$MSG_mod_com--",$donde);
  }
  else
  {
    if ($loggear) { $log->eslog($MSG_mod_ap,2); }
    $con->enviar_mensaje("--$MSG_mod_ap--",$donde);
  }
}

sub no_comentario
{
  my $texto=$_[0];
  my $enc=0;

  my $primero=substr($texto,0,1);
  foreach my $pre (@prefixes)
  {
    if ($primero eq $pre) { $enc=1; }
  }
  return (!( $pref_no_com xor $enc ));
}


sub borr_tmp
{
  unlink($tmp_file) if -e $tmp_file;
  unlink($err_file) if -e $err_file;
}

my @txt_ini=split("\n",$texto_inicial);
$log->init($rebot_conf::logfile);
$log->eslog($txt_ini[0],5);
$log->eslog("$MSG_mod$MSG_modl '$rebot_conf::language'",5);
$log->eslog("$MSG_mod$MSG_mlog '$log'",5);
if ($multi)
{
  $multim->init();
  $log->eslog("$MSG_mod$MSG_modm '$multim'",5);
}
else { $log->eslog("$MSG_mono ('$multim')",5); }
$log->eslog("$MSG_mod$MSG_modp '$con'",5);
$log->eslog($con.': '.$con->texto_inicial(),5);
$con->configurar();
$con->conectar();

BEGIN     # Copiando mensajes en variables locales para simplificar sintaxis
{
  $MSG_bot_descr=${qq(${mod_lang}::bot_descr)};
  $MSG_see_help=${qq(${mod_lang}::see_help)};
  $MSG_see_help2=${qq(${mod_lang}::see_help2)};
  $MSG_ap_no_enc=${qq(${mod_lang}::ap_no_enc)};
  $MSG_av_no_enc=${qq(${mod_lang}::av_no_enc)};
  $MSG_int_no_enc=${qq(${mod_lang}::int_no_enc)};
  $MSG_int_no_ad=${qq(${mod_lang}::int_no_ad)};
  $MSG_ap=${qq(${mod_lang}::ap)};
  $MSG_ap_carg1=${qq(${mod_lang}::ap_carg1)};
  $MSG_ap_carg2=${qq(${mod_lang}::ap_carg2)};
  $MSG_lap=${qq(${mod_lang}::lap)};
  $MSG_ap_end=${qq(${mod_lang}::ap_end)};
  $MSG_av=${qq(${mod_lang}::av)};
  $MSG_av_carg1=${qq(${mod_lang}::av_carg1)};
  $MSG_av_carg2=${qq(${mod_lang}::av_carg2)};
  $MSG_lav=${qq(${mod_lang}::lav)};
  $MSG_av_end=${qq(${mod_lang}::av_end)};
  $MSG_err=${qq(${mod_lang}::err)};
  $MSG_err_lanz=${qq(${mod_lang}::err_lanz)};
  $MSG_err_tmp=${qq(${mod_lang}::err_tmp)};
  $MSG_err_dir=${qq(${mod_lang}::err_dir)};
  $MSG_no_com=${qq(${mod_lang}::no_com)};
  $MSG_mod_err=${qq(${mod_lang}::mod_err)};
  $MSG_mod_com=${qq(${mod_lang}::mod_com)};
  $MSG_mod_ap=${qq(${mod_lang}::mod_ap)};
  $MSG_mod=${qq(${mod_lang}::mod)};
  $MSG_modp=${qq(${mod_lang}::modp)};
  $MSG_modl=${qq(${mod_lang}::modl)};
  $MSG_mlog=${qq(${mod_lang}::mlog)};
  $MSG_modm=${qq(${mod_lang}::modm)};
  $MSG_mosi=${qq(${mod_lang}::mosi)};
  $MSG_mono=${qq(${mod_lang}::mono)};
  $MSG_come=${qq(${mod_lang}::come)};
  $MSG_coma=${qq(${mod_lang}::coma)};
  $MSG_com=${qq(${mod_lang}::com)};
  $MSG_com_no=${qq(${mod_lang}::com_no)};
  $MSG_end=${qq(${mod_lang}::end)};
  $MSG_ncpre=${qq(${mod_lang}::ncpre)};
  $MSG_ncprel=${qq(${mod_lang}::ncprel)};
  $MSG_args=${qq(${mod_lang}::args)};
  $MSG_noargs=${qq(${mod_lang}::noargs)};
  $MSG_help=${qq(${mod_lang}::help)};
  $MSG_help2=${qq(${mod_lang}::help2)};
  $MSG_help_c=${qq(${mod_lang}::help_c)};
  $MSG_help_c2=${qq(${mod_lang}::help_c2)};
  $MSG_help_nc=${qq(${mod_lang}::help_nc)};
  $COM_cargar=${qq(${mod_lang}::cargar)};
  $COM_jugar=${qq(${mod_lang}::jugar)};
  $COM_aventuras=${qq(${mod_lang}::aventuras)};
  $COM_juegos=${qq(${mod_lang}::juegos)};
  $COM_interpretes=${qq(${mod_lang}::interpretes)};
  $COM_ejecutar=${qq(${mod_lang}::ejecutar)};
  $COM_aplicaciones=${qq(${mod_lang}::aplicaciones)};
  $COM_cambio=${qq(${mod_lang}::cambio)};
  $COM_cambiar=${qq(${mod_lang}::cambiar)};
  $COM_multi=${qq(${mod_lang}::multi)};
  $COM_ayuda=${qq(${mod_lang}::ayuda)};
  $COM_interrogante=${qq(${mod_lang}::interrogante)};
  $xml_end='[^<]*<\?xml +version=("|\')1.0("|\') *\?> *<rebot +id=("|\')p'.$$.'("|\') *> *<application +action=("|\')end("|\') *(/>|> *</application *>) *</rebot *>.*';
}

END
{
  if ($multi) { $multim->close(); }
  borr_tmp();
  $log->eslog($MSG_end,4);
  $log->end();
}
