/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "next.h"
#include "gettext-more.h"
#include "xvasprintf.h"

static struct argp_option options[] = 
{
    {0}
};

static error_t 
parse_opt (int key, char *arg, struct argp_state *state)
{
  struct reddit_next_options_t *opt = NULL;
  if (state)
    opt = (struct reddit_next_options_t*) state->input;
  switch (key)
    {
    case ARGP_KEY_ARG:
        {
          if (!opt->parsing_errors)
            {
              argp_failure (state, 0, 0, 
                            _("This command doesn't take an argument."));
              opt->parsing_errors = 1;
            }
        }
      break;
    case ARGP_KEY_INIT:
      opt->parsing_errors = 0;
      break;
    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}

struct argp reddit_next_argp = { options, parse_opt, "", N_("Go to the next page.\v") };

int 
reddit_next_parse_argp (struct reddit_state_t *state, int argc, char **argv, struct argp *argp)
{
  int err = 0;
  struct reddit_next_options_t return_options;
  return_options.state = state;

  err = argp_parse (argp, argc, argv, ARGP_NO_EXIT,  0, &return_options);
  if (!err && !return_options.parsing_errors && ! argp_help_check (argc, argv))
    return reddit_next (state, &return_options);
  else
    return 0;
}

int 
reddit_next(struct reddit_state_t *state, struct reddit_next_options_t *options)
{
  int response = 0;
  int err = 0;
  char *page = xasprintf ("?count=%d&after=%s", 
                          state->stories[state->num_stories-1].story_number,
                           state->stories[state->num_stories-1].id);
  err = reddit_load_and_show_stories (state, page, &response);
  if (err)
    {
      fprintf (state->out, _("Error: Couldn't get the next page.  "
                             "(HTTP /1.1 %d err=%d)\n"), response, err);
      err = 0;
    }
  free (page);
  return err;
}
