/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_STORIES_H
#define REDDIT_STORIES_H 1

#include <argp.h>
#include "reddit_priv.h"
#include "story.h"
int reddit_load_stories (struct reddit_state_t *state, char *url, struct reddit_story_t **stories, int *resp);
void reddit_show_stories (struct reddit_state_t *state);
char * htmltotext (struct reddit_state_t *state, char *html);
void reddit_free_stories (struct reddit_story_t *stories, int num_stories);
struct reddit_story_t * reddit_find_story_with_id (struct reddit_state_t *state, int story_number);
#endif
