/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "reload.h"
#include "gettext-more.h"

static struct argp_option options[] = 
{
    {0}
};

static error_t 
parse_opt (int key, char *arg, struct argp_state *state)
{
  struct reddit_reload_options_t *opt = NULL;
  if (state)
    opt = (struct reddit_reload_options_t*) state->input;
  switch (key)
    {
    case ARGP_KEY_ARG:
        {
          if (!opt->parsing_errors)
            {
              argp_failure (state, 0, 0, 
                            _("This command doesn't take an argument."));
              opt->parsing_errors = 1;
            }
        }
      break;
    case ARGP_KEY_INIT:
      opt->parsing_errors = 0;
      break;
    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}

struct argp reddit_reload_argp = { options, parse_opt, "", 
  N_("Re-download the list of the stories and display them.\v"
     "Save bandwidth by using the `ls' command.") };

int 
reddit_reload_parse_argp (struct reddit_state_t *state, int argc, char **argv, struct argp *argp)
{
  int err = 0;
  struct reddit_reload_options_t reload_options;
  reload_options.state = state;

  err = argp_parse (argp, argc, argv, ARGP_NO_EXIT, 0, &reload_options);

  if (!err && !reload_options.parsing_errors && !argp_help_check (argc, argv))
    return reddit_reload (state, &reload_options);
  else
    return 0;
}

int 
reddit_reload (struct reddit_state_t *state, struct reddit_reload_options_t *options)
{
  int err = 0;
  int response = 0;
  err = reddit_load_and_show_stories (state, NULL, -1, NULL, &response);
  if (err)
    {
      fprintf (state->out, _("Error: Couldn't reload the page.  "
                             "(HTTP /1.1 %d err=%d)\n"), response, err);
      err = 0;
    }
  return err;
}
