/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "return.h"
#include "gettext-more.h"

static struct argp_option options[] = 
{
    {0}
};

static error_t 
parse_opt (int key, char *arg, struct argp_state *state)
{
  struct reddit_return_options_t *opt = NULL;
  if (state)
    opt = (struct reddit_return_options_t*) state->input;
  switch (key)
    {
    case ARGP_KEY_ARG:
        {
          if (!opt->parsing_errors)
            {
              argp_failure (state, 0, 0, 
                            _("This command doesn't take an argument.  "
                              "Maybe you don't want to return to reddit?  "
                              "Try the gosub command instead."));
              opt->parsing_errors = 1;
            }
        }
      break;
    case ARGP_KEY_INIT:
      opt->parsing_errors = 0;
      break;
    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}

struct argp reddit_return_argp = { options, parse_opt, "", N_("Go back to the main reddit.\v") };

int 
reddit_return_parse_argp (struct reddit_state_t *state, int argc, char **argv, struct argp *argp)
{
  int err = 0;
  struct reddit_return_options_t return_options;
  return_options.state = state;

  err = argp_parse (argp, argc, argv, ARGP_NO_EXIT, 0, &return_options);
  if (!err && !return_options.parsing_errors && !argp_help_check (argc, argv))
    return reddit_return (state, &return_options);
  else
    return 0;
}

int 
reddit_return (struct reddit_state_t *state, struct reddit_return_options_t *options)
{
  int err = 0;
  int response = 0;
  err = reddit_load_and_show_stories (state, "", 0, "all", &response);
  if (err)
    {
      fprintf (state->out, _("Error: Couldn't go back to the main page on %s.  "
                             "(HTTP /1.1 %d err=%d)\n"), REDDIT_SITE,
                             response, err);
      err = 0;
    }
  return err;
}
