/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_SHARE_H
#define REDDIT_SHARE_H 1

#include <config.h>
#include <stdio.h>
#include <argp.h>
#include "reddit_priv.h"

struct reddit_share_options_t
{
  int story_id;
  char *to_email;
  char *from_name;
  char *reply_address;
  int add_message;
  char *message;
  struct reddit_state_t *state;
  int parsing_errors;
};

char * argp_parse_email (struct argp_state *state, char *arg, struct reddit_state_t *r); 
int reddit_share_parse_argp (struct reddit_state_t *, int argc, char **argv, struct argp *);
int reddit_share (struct reddit_state_t *, struct reddit_share_options_t *);
extern struct argp reddit_share_argp;
#endif
