/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_PRIV_H
#define REDDIT_PRIV_H 1

#include <argp.h>
#include "story.h"

#include "reddit.h"

int reddit_load_and_show_stories (struct reddit_state_t *state, char *page, int whats, char *subreddit, int *response);
void reddit_reshow_stories (struct reddit_state_t *state);
char * reddit_construct_url (struct reddit_state_t *state, char *page, int whats, char *subreddit);
int argp_help_check (int argc, char **argv);
int reddit_update_modhash (struct reddit_state_t *state);
void reddit_line (struct reddit_state_t *state);
void reddit_banner (struct reddit_state_t *state, char *title);
void reddit_unknown_command (struct reddit_state_t *state);
int reddit_post (struct reddit_state_t *state, char *action, char *post, int *resp, char **msg);
int reddintf (struct reddit_state_t *state, char *fmt, ...);
error_t noargs_parse_opt (int key, char *arg, struct argp_state *state);

#define REDDIT_SITE             "www.reddit.com" //no prefix, no slashes.
#define REDDIT_COOKIEJAR        "/tmp/" PACKAGE ".crumbs"
#define REDDIT_WALLET_PASS      "thisisinsecurebutbetterthanplaintext"
#endif
