/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_GREP_H
#define REDDIT_GREP_H 1

#include <config.h>
#include <argp.h>
#include "reddit.h"

struct reddit_grep_options_t
{
  char *search_terms; //argz
  size_t search_terms_len; //argz_len
  char *reddits;
  size_t reddits_len;
  char *urls;
  size_t urls_len;
  char *sites;
  size_t sites_len;
  char *selftext;
  size_t selftext_len;
  char *authors;
  size_t authors_len;
  int nsfw;
  int is_self;
  int search_in_this_reddit;
  int parsing_errors;
  struct reddit_state_t *state;
};

int reddit_grep_parse_argp (struct reddit_state_t *, int argc, char **argv, struct argp *);
int reddit_grep (struct reddit_state_t *, struct reddit_grep_options_t *options);
extern struct argp reddit_grep_argp;
#endif
