/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_LOGIN_H
#define REDDIT_LOGIN_H 1

#include <config.h>
#include <argp.h>
#include "reddit.h"

struct reddit_login_options_t
{
  char *username;
  char *password;
  int no_wallet;
  struct reddit_state_t *state;
  int parsing_errors;
};

int reddit_check_for_session_cookie (struct reddit_state_t *state);
int reddit_login_parse_argp (struct reddit_state_t *, int argc, char **argv, struct argp *);
int reddit_login (struct reddit_state_t *, struct reddit_login_options_t *);
extern struct argp reddit_login_argp;
#endif
