/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_H
#define REDDIT_H 1

#include <glib.h>
#include <curl/curl.h>

// types
struct reddit_options_t
{
  int quiet;
  char *username;
  char *subreddit;
  char *proxy;
  int proxy_port;
  char *wallet;
  char *host;
  int no_initial_stories;
  char *cookie_file;
  int banner;
};

struct reddit_state_t
{
  int logged_in;
  char *username;
  CURL *curl;
  FILE *out;
  struct reddit_story_t *stories;
  int num_stories;
  char *command; //current command we're working on.
  int story_number; //current story number we're looking at.
  int whats; //what tab we're on.
  char *subreddit; //what subreddit we're in.
  gchar *browser_binary; //where the browser program is living 
  gchar *browser_options; //what options to give to the browser program
  gchar *links_binary; //where the links program is living (for html2text)
  gchar *openssl_binary; //where the openssl program is living (for wallets).
  char *modhash; //the last modhash we saw.
  char *page; //what page we're on.
  int columns; //how many columns are on our screen.
  int silent; //don't print any messages.
  char *wallet; //a copy of the pointer from options
  char *site; //usually www.reddit.com.  overridden with --host
  char *reddits; //a list of subreddits (argz)
  size_t reddits_len;//length of subreddits (argz_len)
  int page_size; //how many stories per page.
  char *search; //current search terms.
  int banner; //whether or not to show the bottom banner.
};

//the main loop
int reddit (struct reddit_options_t *opts);

//the non-argp commands
int reddit_history(struct reddit_state_t *state);
int reddit_set_banner(struct reddit_state_t *state, char *value);
int reddit_warranty (struct reddit_state_t *state);
int reddit_browser (struct reddit_state_t *state);
int reddit_set_browser (struct reddit_state_t *state, char *value);
int reddit_browser_options (struct reddit_state_t *state);
int reddit_set_browser_options (struct reddit_state_t *state, char *value);
int reddit_set_history (struct reddit_state_t *state, char *value);
int reddit_page_size(struct reddit_state_t *state);
int reddit_set_page_size(struct reddit_state_t *state, char *value);
//the argp-based commands
#include "upvote.h"
#include "downvote.h"
#include "discuss.h"
#include "gosub.h"
#include "return.h"
#include "ls.h"
#include "reload.h"
#include "next.h"
#include "prev.h"
#include "view.h"
#include "share.h"
#include "whats.h"
#include "login.h"
#include "submit.h"
#include "save.h"
#endif
