/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#include <config.h>
#include <stdlib.h>
#include "gettext-more.h"
#include "reddit_priv.h"
#include "return.h"

struct argp reddit_return_argp = { NULL, noargs_parse_opt, "", N_("Go back to the main reddit.\v") };

int 
reddit_return_parse_argp (struct reddit_state_t *state, int argc, char **argv, struct argp *argp)
{
  int err = 0;
  int parsing_errors;

  err = argp_parse (argp, argc, argv, ARGP_NO_EXIT, 0, &parsing_errors);
  if (!err && !parsing_errors && !argp_help_check (argc, argv))
    return reddit_return (state);
  else
    return 0;
}

int 
reddit_return (struct reddit_state_t *state)
{
  int err = 0;
  int response = 0;
  err = reddit_load_and_show_stories (state, "", 0, "all", "", &response);
  if (err)
    {
      reddintf (state, _("Error: Couldn't go back to the main page on %s.  "
                         "(HTTP /1.1 %d err=%d)\n"), state->site,
                response, err);
      err = 0;
    }
  return err;
}
