/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_VIEW_H
#define REDDIT_VIEW_H 1

#include <config.h>
#include <argp.h>
#include "reddit.h"

struct reddit_view_options_t
{
  int story_id;
  struct reddit_state_t *state;
  int parsing_errors;
};

int reddit_spawn_viewer_for_link (struct reddit_state_t *state, char *link);
int reddit_view_parse_argp (struct reddit_state_t *, int argc, char **argv, struct argp *);
int reddit_view (struct reddit_state_t *, struct reddit_view_options_t *);
extern struct argp reddit_view_argp;
#endif
