#include <config.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <glib.h>
#include "reddit.h"
#include "stories.h"

int 
main(int argc, char **argv)
{
  struct reddit_state_t state;
  memset (&state, 0, sizeof (state));
  state.links_binary = g_find_program_in_path ("links");
  state.logged_in = 0;
  state.num_stories = 
    reddit_load_stories_from_file (&state, 
                                   fopen (TESTDATADIR "/fp-0002.html", "r"),
                                   &state.stories);
  if (state.num_stories != 25)
    return 1;
  if (state.logged_in == 0)
    return 2;
  if (state.username == NULL)
    return 3;
  if (state.modhash == NULL)
    return 4;
  return 0;
}
