#include <config.h>
#include <stdio.h>
#include "reddit.h"
#ifdef HAVE_LIBREADLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif

int 
main(int argc, char **argv)
{
  int err;
  struct reddit_state_t state;
  memset (&state, 0, sizeof (state));
  state.silent = 1;
  state.out = stderr;
  err = reddit_set_banner(&state, "on");
  if (err && state.banner == 0)
    return 1;
  err = reddit_set_banner(&state, "off");
  if (err && state.banner == 1)
    return 2;
  err = reddit_set_banner(&state, "On");
  if (err && state.banner == 0)
    return 3;
  err = reddit_set_banner(&state, "Off");
  if (err || state.banner == 1)
    return 4;
  err = reddit_set_banner(&state, "sur");
  if (err == 0 || state.banner == 1)
    return 5;
  err = reddit_set_banner(&state, "ON");
  if (err || state.banner == 0)
    return 6;
  err = reddit_set_banner(&state, "on ");
  if (err == 0 || state.banner == 0)
    return 7;

  err = reddit_set_browser (&state, "/usr/bin/file-not-found-browser");
  if (err == 0 || state.browser_binary != NULL)
    return 8;
  FILE *fileptr = fopen ("/tmp/file-found-browser", "a");
  err = reddit_set_browser (&state, "/tmp/file-found-browser");
  remove ("/tmp/file-found-browser");
  fclose (fileptr);
  if (err || strcmp (state.browser_binary, "/tmp/file-found-browser") != 0)
    return 9;
  err = reddit_set_browser (&state, "/usr/bin/file-not-found-browser");
  if (err == 0 || strcmp (state.browser_binary, "/tmp/file-found-browser") != 0)
    return 10;

  err = reddit_set_browser_options (&state, "--foo");
  if (err || strcmp (state.browser_options, "--foo") != 0)
    return 11;

#ifdef HAVE_LIBREADLINE
  int val = 0;
  rl_initialize ();
  err = reddit_set_history (&state, "10");
  reddit_history (&state, &val);
  if (err || val != 10)
    return 12;
  err = reddit_set_history (&state, "-1");
  reddit_history (&state, &val);
  if (err || val != -1)
    return 13;
  err = reddit_set_history (&state, "-2");
  reddit_history (&state, &val);
  if (err == 0 || val != -1)
    return 14;
  err = reddit_set_history (&state, "0x00000010");
  reddit_history (&state, &val);
  if (err || val != 16)
    return 15;
  err = reddit_set_history (&state, "10 hmm");
  reddit_history (&state, &val);
  if (err || val != 10)
    return 16;
#endif

  reddit_set_page_size (&state, "10");
  if (state.page_size != 10)
    return 17;
  reddit_set_page_size (&state, "11 hmm");
  if (state.page_size != 11)
    return 18;
  reddit_set_page_size (&state, "1");
  if (state.page_size != 1)
    return 19;
  reddit_set_page_size (&state, "0");
  if (state.page_size != 0)
    return 20;
  reddit_set_page_size (&state, "-1");
  if (state.page_size != 0)
    return 21;

  return 0;
}
