#include <config.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <glib.h>
#include "reddit.h"
#include "whoami.h"

int 
main(int argc, char **argv)
{
  struct reddit_state_t state;
  memset (&state, 0, sizeof (state));
  state.links_binary = g_find_program_in_path ("links");
  state.logged_in = 1;
  int link = -1;
  int comment = -1;
  char *age = NULL;
  int err = reddit_get_stats_from_file (&state, 
                                        fopen (TESTDATADIR "/user-0001.html", 
                                               "r"), &link, &comment, &age);
  if (err != 0)
    return 1;
  if (age == NULL)
    return 2;
  if (link == -1)
    return 3;
  if (comment == -1)
    return 4;
  return 0;
}
