/*
 * Copyright (C) 2003 INRIA
 *
 *	INRIA
 *	Domaine de Voluceau
 *	Rocquencourt - B.P. 105
 *	78153 Le Chesnay Cedex - France
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Loic Dachary <loic@gnu.org>
 * 
 */

/*
 * For a detailed description see rfid_reader(3)
 */

#ifndef _RFID_IO_H_
#define _RFID_IO_H_

#include <sys/param.h>
#include <sys/types.h>
#include <termios.h>

#define RFID_IO_UNDEFINED	-1

typedef struct {
  char device[PATH_MAX + 1];
  int timeout;
  int fd;
  int lock;
  int speed;
  int nbits;
  int parity;
  int stopbits;
} rfid_io_t;

#define RFID_IO_LOCK		1
#define RFID_IO_NOLOCK		0

int rfid_io_alloc(rfid_io_t** iop);
int rfid_io_free(rfid_io_t* io);
int rfid_io_dup(rfid_io_t* from, rfid_io_t** top);
int rfid_io_init(rfid_io_t* io, const char* pathname);
/* man termios(3) for valid values of speed, nbits, parity and stopbits. */
int rfid_io_set(rfid_io_t* io, int speed, int nbits, int parity, int stopbits, int lock);
int rfid_io_configure(rfid_io_t* io);
int rfid_io_open(rfid_io_t* io);
int rfid_io_read(rfid_io_t* io, u_int8_t* buffer, int buffer_size);
int rfid_io_end(rfid_io_t* io);

#endif /* _RFID_IO_H_ */
