; Copyright (c) 2004, Jonah Nathaniel Beckford
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in
;   the documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of the author nor the names of its contributors
;   may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
; FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
; COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGE.
;
; jonah@usermail.com

;; From Boost Graph Library.  See COPYRIGHT.
(define-record-type dfs-visitor-t
  ;; create a new dfs-visitor
  (dfs-visitor
    init start discover examine
    tree-edge back-edge forward-or-cross-edge finish)
  ;; predicate
  dfs-visitor?
  ;; accessors
  (init dfs-visitor-init set-dfs-visitor-init!)
  (start dfs-visitor-start set-dfs-visitor-start!)
  (discover dfs-visitor-discover set-dfs-visitor-discover!)
  (examine dfs-visitor-examine set-dfs-visitor-examine!)
  (tree-edge dfs-visitor-tree-edge set-dfs-visitor-tree-edge!)
  (back-edge dfs-visitor-back-edge set-dfs-visitor-back-edge!)
  (forward-or-cross-edge dfs-visitor-forward-or-cross-edge set-dfs-visitor-forward-or-cross-edge!)
  (finish dfs-visitor-finish set-dfs-visitor-finish!))

;; create a new, null dfs-visitor
(define (null-dfs-visitor)
  (dfs-visitor #f #f #f #f #f #f #f #f))

