; Copyright (c) 2004, Jonah Nathaniel Beckford
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in
;   the documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of the author nor the names of its contributors
;   may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
; FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
; COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGE.
;
; jonah@usermail.com

(lambda (GTYPE VARGS streamed? bidirectional? edge-properties)
  (define (pad . args)
    (string->symbol
      (apply string-append
        (map (lambda (a)
               (cond
                 [(string? a) a]
                 [(symbol? a) (symbol->string a)]
                 [else "UNKNOWN_PAD_SYMBOL"]))
          args))))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  (let* (
         [NP (length edge-properties)]
         [el (pad GTYPE "-edge-list")]
         [el? (gensym)]
         [make-el (gensym)]
         [el-tlist (gensym)]
         [set-el-tlist! (gensym)]         
         [el-tnum (gensym)]
         [set-el-tnum! (gensym)]         
         [rec (pad GTYPE "-edge")]
         [rec? (gensym)]
         [make-rec (gensym)]
         [rec-target (gensym)]
         [set-rec-target! (gensym)]
         [rec-props (gensym)]
         [set-rec-props! (gensym)]
         
         [edge-set? (pad GTYPE "-edge-set?")]
         [constructor (pad "##carp#make-" GTYPE "-el")]
         [add-directed-edge! (pad "##carp#" GTYPE "-add-directed-edge!")]
         [remove-directed-edge! (pad "##carp#" GTYPE "-remove-directed-edge!")]
         [edge (pad GTYPE "-edge")]
         [source (pad GTYPE "-source")]
         [target (pad GTYPE "-target")]
         [edges (pad "##carp#" GTYPE "-edges")]
         [edges* (pad "##carp#" GTYPE "-edges*")]
         [edge-at (pad GTYPE "-edge-at")]
         [degree (pad "##carp#" GTYPE "-degree")]
         [transform-vertices! (pad "##carp#" GTYPE "-transform-vertices!")]
         
         ;; imports
         [out-edge-list (pad "##carp#" GTYPE "-out-edge-list")]
         [in-edge-list (pad "##carp#" GTYPE "-in-edge-list")]
         [vertex-eq? (pad GTYPE "-vertex-eq?")]
         )
    `(begin
       (define-macro ,edge-set? (lambda () `#f))
       (define-record-type ,el
         (,make-el tlist tnum)
         ,el?
         (tlist ,el-tlist ,set-el-tlist!)
         (tnum ,el-tnum ,set-el-tnum!))
       (define-record-printer ,el
         (lambda (x p)
           (fprintf p "Edge List el-slist~%")
           (fprintf p "degree\t~S" (,el-tnum x))))
       (define-record-type ,rec
         (,make-rec target props)
         ,rec?
         (target ,rec-target ,set-rec-target!)
         (props ,rec-props ,set-rec-props!))
       (define-record-printer ,rec
         (lambda (x p)
           (fprintf p "Edge | target vertex\t~S" (,rec-target x))))
       (define ,constructor
         (lambda (g)
           (,make-el '() 0)))
       ,@(let ([index -1])
           (map
             (lambda (prop)
               (let ([getter (pad GTYPE "-" prop)]
                     [setter! (pad "set-" GTYPE "-" prop "!")]
		     [pmap (pad GTYPE "-" prop "-map")])
                 (set! index (add1 index))
                 `(begin
                    (define ,getter
                      (lambda (g e)
                        (vector-ref (,rec-props (cdr e)) ,index)))
                    (define ,setter!
                      (lambda (g e p)
                        (vector-set! (,rec-props (cdr e)) ,index p)))
                    (define ,pmap (cons ,getter ,setter!)))))
             edge-properties))       
       (define ,add-directed-edge!
         (lambda (g u u-el v)
           (let* ([u-tlist (,el-tlist u-el)]
                  [v-rec (,make-rec v (make-vector ,NP #f))])
             (set! u-tlist (cons v-rec u-tlist))
             (,set-el-tlist! u-el u-tlist)
             (,set-el-tnum! u-el (add1 (,el-tnum u-el)))
             (cons u v-rec))))
       (define ,remove-directed-edge!
         (lambda (g u u-el v)
           (let* ([u-tlist (,el-tlist u-el)])
             (let find ([tlist u-tlist] [predecessor #f])
               (cond
                 [(null? tlist) 
		  (error "Could not remove directed edge" g u u-el v)]
                 [(,vertex-eq? g v (,rec-target (car tlist)))
                  (cond
                    [predecessor (set-cdr! predecessor (cdr tlist))]
                    [else (,set-el-tlist! u-el (cdr tlist))])
                  (,set-el-tnum! u-el (sub1 (,el-tnum u-el)))
                  #t]
                 [else (find (cdr tlist) tlist)])))))
       (define ,edge
         (lambda (g u v)
           (let* ([u-el (,out-edge-list g u)]
                  [u-tlist (,el-tlist u-el)])
             (let find ([tlist u-tlist])
               (cond
                 [(null? tlist) #f]
                 [(,vertex-eq? g v (,rec-target (car tlist)))
                  (cons u (car tlist))]
                 [else (find (cdr tlist))])))))
       (define ,source
         (lambda (g e)
           (car e)))
       (define ,target
         (lambda (g e)
           (,rec-target (cdr e))))
       (define ,edges
         (lambda (g u u-el out?)
           (map
             (lambda (v-rec)
               (if out? (cons u v-rec) (,edge g (,rec-target v-rec) u)))
             (,el-tlist u-el))))
       (define ,edges*
         (lambda (g u u-el out?)
           (stream-map
             (lambda (v-rec)
               (if out? (cons u v-rec) (,edge g (,rec-target v-rec) u)))
             (list->stream (,el-tlist u-el)))))
       (define ,edge-at
         (lambda (g u n)
           (let* ([u-el (,out-edge-list g u)]
                  [u-tlist (,el-tlist u-el)]
                  [u-tnum (,el-tnum u-el)]
                  [where (- u-tnum n 1)])
             (when (< where)
               (error "Invalid el-slist edge index"))
             (cons u (list-ref u-tlist where)))))
       (define ,degree
         (lambda (g u u-el)
           (,el-tnum u-el)))
       (define ,transform-vertices!
         (lambda (proc g u)
           (define (x v-rec)
               (,set-rec-target! v-rec (proc (,rec-target v-rec))))
           (for-each x (,el-tlist (,out-edge-list g u)))
           ,@(when-bi `(for-each x (,el-tlist (,in-edge-list g u))))))
       )))