#!/bin/bash

. ./VERSION

source ./DefConf.inc

DOCFILES="COPYING ChangeLog README INSTALL TODO sample_monthly sample_rc"
MANFILES="rottlog.8 rottlogex.5"

echo "install script for Rot[t]Log v.$VERSION"
echo
echo "Updating bash codes..."

esc_MAINPATH=${ROTT_ETCDIR//\//\\/}
esc_STATPATH=${ROTT_STATPATH//\//\\/}
sed -e s/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/ \
    -e s/^STATPATH=.*/STATPATH=\"$esc_STATPATH\"/ rottlog >newrottlog
if [ ! -s newrottlog ]; then
  echo "Error using sed to modify rottlog!!"
  echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
  echo "detailed information about error messages and you environnement."
  echo "I'll try to solve this problem as soon as possible. Thanks."
  exit 3
else
  mv newrottlog rottlog
fi
sed -e s/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/ virottrc >newvirottrc
if [ ! -s newvirottrc ]; then
  echo "Error using sed to modify virottrc!!"
  echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
  echo "detailed information about error messages and you environnement."
  echo "I'll try to solve this problem as soon as possible. Thanks."
  exit 3
else
  mv newvirottrc virottrc
fi


mkdir -p $BINDIR
rm -f $BINDIR/rottlog
rm -f $BINDIR/virott[rc,month,day,week]*

install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE rottlog $BINDIR
install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE virottrc $BINDIR
ln -sf $BINDIR/virottrc $BINDIR/virottday
ln -sf $BINDIR/virottrc $BINDIR/virottweek
ln -sf $BINDIR/virottrc $BINDIR/virottmonth

mkdir -p $DOCDIR/rottlog-$VERSION
for D in $DOCFILES; do
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $D $DOCDIR/rottlog-$VERSION
done

for M in $MANFILES; do
  posnum=${#M}
  posnum=$[ posnum - 1 ]
  number=${M:posnum}
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $M "$MANDIR/man"$number
  if [ $MANGZIP -eq 1 ]; then
    gzip -9 "$MANDIR/man"$number/$M
  fi
done

mkdir -p $ROTT_ETCDIR
chmod $ETC_MODE $ROTT_ETCDIR

mkdir -p $ROTT_STATPATH
chmod $STAT_MODE $ROTT_STATPATH

#crontab -l $LOG_OWN >tabella_cron
#echo "00 23 * * * /usr/sbin/rottlog" >>tabella_cron
#crontab tabella_cron -u $LOG_OWN
#crontab -e -u $LOG_OWN

echo "Installation finished. Now Rot[t]Log can be used in command line mode"
echo "or using crontab."
echo "If there are some bug please send me an e-mail explaining to me problems"
echo "at address: stefko5@inwind.it"



