#!/bin/bash
# Copyright (C) 2001,2002 by Stefano Falsetto
# e-mail contact ....: mailto:stefko5@inwind.it
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#

source ./VERSION
echo "Install script for Rot[t]Log v.$VERSION"
echo

echo -n "Checking for sed... "
SED=$(which sed)
if [ -z "$SED" ]; then
  echo
  echo "This installation script requires (GNU) sed."
  echo "Please install it before to run this script."
  exit 99
fi
echo "Done"

echo -n "Checking for awk..."
AWK=$(which awk)
if [ -z "$AWK" ]; then
  echo
  echo "Rot[t]Log script requires GNU awk."
  echo "Please install it before to run this script."
  exit 99
fi
echo "Done"

source ./DefConf.inc

DOCFILES="COPYING ChangeLog README INSTALL TODO sample_monthly sample_rc"
MANFILES="rottlog.8 rottlogconf.5 rottlogex.5"

echo "Updating bash codes... "

esc_MAINPATH=${ROTT_ETCDIR//\//\\/}
esc_STATPATH=${ROTT_STATPATH//\//\\/}
sed -e s/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/ \
    -e s/^STATPATH=.*/STATPATH=\"$esc_STATPATH\"/ rottlog >newrottlog
if [ ! -s newrottlog ]; then
  echo "Error using sed to modify rottlog!!"
  echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
  echo "detailed information about error messages and you environnement."
  echo "I'll try to solve this problem as soon as possible. Thanks."
  exit 3
else
  mv newrottlog rottlog
fi
sed -e s/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/ virottrc >newvirottrc
if [ ! -s newvirottrc ]; then
  echo "Error using sed to modify virottrc!!"
  echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
  echo "detailed information about error messages and you environnement."
  echo "I'll try to solve this problem as soon as possible. Thanks."
  exit 3
else
  mv newvirottrc virottrc
fi

echo "Updating man pages..."
for M in $MANFILES; do
  posnum=${#M}
  posnum=$[ posnum - 1 ]
  number=${M:posnum}
  sed -e s/\@ETCDIR/$esc_MAINPATH/ \
      -e s/\@STATDIR/$esc_STATPATH/ $M > new-manual-$M
  if [ ! -s new-manual-$M ]; then
    echo "Error using sed to modify $M!!"
    echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
    echo "detailed information about error messages and you environnement."
    echo "I'll try to solve this problem as soon as possible. Thanks."
    exit 3
  fi
  mv new-manual-$M $M
done

mkdir -p $BINDIR
rm -f $BINDIR/rottlog
rm -f $BINDIR/virott[rc,month,day,week]*

install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE rottlog $BINDIR
install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE virottrc $BINDIR
ln -sf $BINDIR/virottrc $BINDIR/virottday
ln -sf $BINDIR/virottrc $BINDIR/virottweek
ln -sf $BINDIR/virottrc $BINDIR/virottmonth

mkdir -p $DOCDIR/rottlog-$VERSION
for D in $DOCFILES; do
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $D $DOCDIR/rottlog-$VERSION
done

for M in $MANFILES; do
  posnum=${#M}
  posnum=$[ posnum - 1 ]
  number=${M:posnum}
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $M "$MANDIR/man"$number
  if [ $MANGZIP -eq 1 ]; then
    gzip -9 "$MANDIR/man"$number/$M
  fi
done

mkdir -p $ROTT_ETCDIR
chmod $ETC_MODE $ROTT_ETCDIR

mkdir -p $ROTT_STATPATH
chmod $STAT_MODE $ROTT_STATPATH

#crontab -l $LOG_OWN >tabella_cron
#echo "00 23 * * * /usr/sbin/rottlog" >>tabella_cron
#crontab tabella_cron -u $LOG_OWN
#crontab -e -u $LOG_OWN

echo "Installation finished. Now Rot[t]Log can be used in command line mode"
echo "or using crontab."
echo "If there are some bug please send me an e-mail explaining to me problems"
echo "at address: stefko5@inwind.it"



