#!/bin/sh
# Copyright (C) 2001,2002 by Stefano Falsetto
# e-mail contact ....: mailto:stefko5@inwind.it
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#

sed_error() {
  echo "Error using sed handling $1!!"
  echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
  echo "detailed information about error messages and you environnement."
  echo "I'll try to solve this problem as soon as possible. Thanks."
  exit 3
}

require_sw () {
  echo
  if [ ! -z "$2" ]; then
    echo "This installation script requires $1."
  else
    echo "Rot[t]Log script requires $1"
  fi
  echo "Please install it before to run this script."
  echo "If it is already installed on your system be sure that it is in"
  echo "the PATH environment variable"
  exit 99
}

source ./VERSION
echo "Install script for Rot[t]Log v.$VERSION"
echo

echo -n "Checking for sed... "
SED=$(which sed)
if [ -z "$SED" ]; then
  require_sw "(GNU) sed"
fi
echo "Done"

echo -n "Checking for awk..."
AWK=$(which awk)
if [ -z "$AWK" ]; then
  require_sw "(GNU) awk"
fi
echo "Done"

echo -n "Checking for grep..."
GREP="$(which grep)"
if [ -z "$GREP" ]; then
  require_sw "(GNU) grep"
fi
echo "Done"

echo -n "Checking for util-linux"
UTIL="$(which cal)"
if [ -z "$UTIL" ]; then
  require_sw "cal (from util-linux)"
fi
echo "Done"

echo -n "Checking for mimencode"
MIMENCODE="$(which mimencode)"
if [ -z "$MIMENCODE" ]; then
  require_sw "mimencode (from metamail package)"
fi

echo -n "Checking for sane bash environment"
TRY="${MAINPATH//\//\\/}"
if [ "$TRY" = "$MAINPATH" ]; then
  echo " (escaping with awk) "
  escape_string() {
    # gensub is a GNU extension to original awk
    #local tmpvar=$(echo $1|awk ' { print gensub("/","\\\\/","G") }')
    local tmpvar=$(echo $1|awk ' { gsub("/","\\\/"); print $0 }')
    eval "$2=\"$tmpvar\""
  }
else
  echo " (escaping with bash) "
  escape_string() {
    eval "$2 = \"${1//\//\\/}\""
  }
fi
echo "Done"

source ./DefConf.inc

DOCFILES="COPYING ChangeLog README INSTALL TODO sample_monthly \
          sample_rc sample_custom"
MANFILES="rottlog.8 rottlogconf.5 rottlogex.5 rottlogrc.5"

echo "Updating bash codes... "

#esc_MAINPATH=${ROTT_ETCDIR//\//\\/}
#esc_STATPATH=${ROTT_STATPATH//\//\\/}
escape_string "$ROTT_ETCDIR" esc_MAINPATH
escape_string "$ROTT_STATPATH" esc_STATPATH

sed -e s/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/ \
    -e s/^STATPATH=.*/STATPATH=\"$esc_STATPATH\"/ rottlog >newrottlog
if [ ! -s newrottlog ]; then
  sed_error rottlog
else
  mv newrottlog rottlog
fi
sed -e s/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/ virottrc >newvirottrc
if [ ! -s newvirottrc ]; then
  sed_error virottrc
else
  mv newvirottrc virottrc
fi

echo "Updating man pages..."
for M in $MANFILES; do
  posnum=${#M}
  posnum=$[ posnum - 1 ]
  number=${M:posnum}
  sed -e s/\@ETCDIR/$esc_MAINPATH/ \
      -e s/\@STATDIR/$esc_STATPATH/ $M > new-manual-$M
  if [ ! -s new-manual-$M ]; then
    sed_error $M
  fi
  mv new-manual-$M $M
done

mkdir -p $BINDIR
rm -f $BINDIR/rottlog
rm -f $BINDIR/virott[rc,month,day,week]*

install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE rottlog $BINDIR
install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE virottrc $BINDIR
for i in custom day week month; do
  ln -sf $BINDIR/virottrc $BINDIR/virott$i
done

mkdir -p $DOCDIR/rottlog-$VERSION
for D in $DOCFILES; do
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $D $DOCDIR/rottlog-$VERSION
done

for M in $MANFILES; do
  posnum=${#M}
  posnum=$[ posnum - 1 ]
  number=${M:posnum}
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $M "$MANDIR/man"$number
  if [ $MANGZIP -eq 1 ]; then
    gzip -9 "$MANDIR/man"$number/$M
  fi
done

mkdir -p $ROTT_ETCDIR
chmod $ETC_MODE $ROTT_ETCDIR

mkdir -p $ROTT_STATPATH
chmod $STAT_MODE $ROTT_STATPATH

#crontab -l $LOG_OWN >tabella_cron
#echo "00 23 * * * /usr/sbin/rottlog" >>tabella_cron
#crontab tabella_cron -u $LOG_OWN
#crontab -e -u $LOG_OWN

echo "Installation finished. Now Rot[t]Log can be used in command line mode"
echo "or using crontab."
echo "If you find some bug please send me an e-mail explaining to me problems"
echo "and as much as possible information at address."
echo "My e-mail address is: stefko5@inwind.it"
echo


