#!/bin/bash

BINDIR="/usr/sbin"
DOCDIR="/usr/doc"
DOCFILES="COPYING ChangeLog README ChangeLog.IT TODO sample_monthly sample_rc"
LOG_OWN="root"
LOG_GROUP="root"

. ./VERSION
echo "Mini-install script for Rot[t]Log v.$VERSION"
echo
mkdir -p $BINDIR
rm -f $BINDIR/rottlog
rm -f $BINDIR/virott[rc,month,day,week]*

install -o $LOG_OWN -g $LOG_GROUP -m 0700 rottlog $BINDIR
install -o $LOG_OWN -g $LOG_GROUP -m 0700 virottrc $BINDIR
ln -sf $BINDIR/virottrc $BINDIR/virottday
ln -sf $BINDIR/virottrc $BINDIR/virottweek
ln -sf $BINDIR/virottrc $BINDIR/virottmonth

mkdir -p $DOCDIR/rottlog-$VERSION
for D in $DOCFILES; do
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $D $DOCDIR/rottlog-$VERSION
done
