/*-GNU-GPL-BEGIN-*
RULI - Resolver User Layer Interface - Querying DNS SRV records
Copyright (C) 2003 Everton da Silva Marques

RULI is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

RULI is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RULI; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/

/*
  $Id: ruli_addr.h,v 1.3 2004/05/28 01:16:49 evertonm Exp $
  */


#ifndef RULI_ADDR_H
#define RULI_ADDR_H


#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>


typedef struct {
  int addr_family;        /* PF_INET, PF_INET6 */
  size_t addr_size; 
  union {
    struct in_addr ipv4;
    struct in6_addr ipv6;
  } addr;
} ruli_addr_t;

/*
 * constructors
 */
ruli_addr_t *ruli_addr_inet_new(struct in_addr ia);
ruli_addr_t *ruli_addr_inet6_new(struct in6_addr ia);

/*
 * access methods
 */
int ruli_addr_family(const ruli_addr_t *addr);
int ruli_addr_size(const ruli_addr_t *addr);
struct in_addr ruli_addr_inet(const ruli_addr_t *addr);
struct in6_addr ruli_addr_inet6(const ruli_addr_t *addr);

/*
 * misc utilities
 */
int ruli_inet6_aton(const char *cp, struct in6_addr *inp);
int ruli_addr_parse(const char *p, ruli_addr_t *addr);
ruli_addr_t *ruli_addr_parse_new(const char *p);
int ruli_addr_print(FILE *out, const ruli_addr_t *addr);

#endif /* RULI_ADDR_H */
