/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of RULI.xs. Do not edit this file, edit RULI.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "RULI.xs"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <ruli.h>

#include "const-c.inc"

static void push_ruli_addr(AV *srv_addrs, const ruli_addr_t *addr)
{
	SV *address;
	char buf[40];

	if (ruli_addr_snprint(buf, 40, addr) < 0)
		return;

	address = newSVpv(buf, strlen(buf));

	av_push(srv_addrs, address);
}

#line 34 "RULI.c"

/* INCLUDE:  Including 'const-xs.inc' from 'RULI.xs' */

XS(XS_RULI_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_RULI_constant)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RULI::constant(sv)");
    SP -= items;
    {
#line 4 "const-xs.inc"
#ifdef dXSTARG
	dXSTARG; /* Faster if we have it.  */
#else
	dTARGET;
#endif
	STRLEN		len;
        int		type;
	/* IV		iv;	Uncomment this if you need to return IVs */
	/* NV		nv;	Uncomment this if you need to return NVs */
	/* const char	*pv;	Uncomment this if you need to return PVs */
#line 57 "RULI.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
#line 18 "const-xs.inc"
	type = constant(aTHX_ s, len);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv = sv_2mortal(newSVpvf("%s is not a valid RULI macro", s));
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined RULI macro %s, used", s));
          PUSHs(sv);
          break;
	/* Uncomment this if you need to return IVs
        case PERL_constant_ISIV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHi(iv);
          break; */
	/* Uncomment this if you need to return NOs
        case PERL_constant_ISNO:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_no);
          break; */
	/* Uncomment this if you need to return NVs
        case PERL_constant_ISNV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHn(nv);
          break; */
	/* Uncomment this if you need to return PVs
        case PERL_constant_ISPV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, strlen(pv));
          break; */
	/* Uncomment this if you need to return PVNs
        case PERL_constant_ISPVN:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, iv);
          break; */
	/* Uncomment this if you need to return SVs
        case PERL_constant_ISSV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break; */
	/* Uncomment this if you need to return UNDEFs
        case PERL_constant_ISUNDEF:
          break; */
	/* Uncomment this if you need to return UVs
        case PERL_constant_ISUV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHu((UV)iv);
          break; */
	/* Uncomment this if you need to return YESs
        case PERL_constant_ISYES:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_yes);
          break; */
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing RULI macro %s, used",
               type, s));
          PUSHs(sv);
        }
#line 131 "RULI.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'RULI.xs' from 'const-xs.inc' */

XS(XS_RULI_ruli_sync_query); /* prototype to pass -Wmissing-prototypes */
XS(XS_RULI_ruli_sync_query)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: RULI::ruli_sync_query(service, domain, fallback_port, options)");
    {
	const char *	service = (const char *)SvPV_nolen(ST(0));
	const char *	domain = (const char *)SvPV_nolen(ST(1));
	int	fallback_port = (int)SvIV(ST(2));
	long	options = (long)SvIV(ST(3));
	SV *	RETVAL;
#line 37 "RULI.xs"
	ruli_sync_t *sync_query;
	int srv_code;
	ruli_list_t *srv_list;
	int srv_list_size;
	int i;
        AV* srv_array;
        SV* srv_array_ref;
	const char *label_target    = "target";
	const char *label_priority  = "priority";
	const char *label_weight    = "weight";
	const char *label_port      = "port";
	const char *label_addr_list = "addr_list";
	SV* key_target    = newSVpv(label_target,    strlen(label_target));
	SV* key_priority  = newSVpv(label_priority,  strlen(label_priority));
	SV* key_weight    = newSVpv(label_weight,    strlen(label_weight));
	SV* key_port      = newSVpv(label_port,      strlen(label_port));
	SV* key_addr_list = newSVpv(label_addr_list, strlen(label_addr_list));

	/* Submit query */
	sync_query =ruli_sync_query(service, domain, fallback_port, options);
	if (!sync_query)
		XSRETURN_UNDEF;

	/* Underlying SRV query failure? */
	srv_code = ruli_sync_srv_code(sync_query);
	if (srv_code == RULI_SRV_CODE_ALARM) {
		ruli_sync_delete(sync_query);
		XSRETURN_UNDEF;
	}

	/* Service provided? */
	if (srv_code == RULI_SRV_CODE_UNAVAILABLE) {
		ruli_sync_delete(sync_query);
		XSRETURN_UNDEF;
	}

	/* Server RCODE? */
	if (srv_code) {
		int rcode = ruli_sync_rcode(sync_query);
		if (rcode) {
			ruli_sync_delete(sync_query);
			XSRETURN_UNDEF;
		}

		ruli_sync_delete(sync_query);
		XSRETURN_UNDEF;
	}

	srv_list = ruli_sync_srv_list(sync_query);
	srv_list_size = ruli_list_size(srv_list);

	srv_array = newAV();
	srv_array_ref = newRV_inc((SV*) srv_array);

	/* Scan list of SRV records */
	for (i = 0; i < srv_list_size; ++i) {
		ruli_srv_entry_t *entry         = ruli_list_get(srv_list, i);
		ruli_list_t      *addr_list     = &entry->addr_list;
		int              addr_list_size = ruli_list_size(addr_list);
		char             txt_dname_buf[RULI_LIMIT_DNAME_TEXT_BUFSZ];
		int              txt_dname_len;
		int              j;

		HV*	srv;
		SV*	srv_ref;
		SV*	target;
		SV*	priority;
		SV*	weight;
		SV*	port;
		AV*	srv_addrs;
		SV*	srv_addrs_ref;

		if (ruli_dname_decode(txt_dname_buf, 
			RULI_LIMIT_DNAME_TEXT_BUFSZ,
	       		&txt_dname_len,
			entry->target, entry->target_len))
			continue;

		target   = newSVpv(txt_dname_buf, txt_dname_len);
		priority = newSViv(entry->priority);
		weight   = newSViv(entry->weight);
		port     = newSViv(entry->port);

		srv = newHV();
		srv_ref = newRV_inc((SV*) srv);
		av_push(srv_array, srv_ref);

		hv_store_ent(srv, key_target, target, 0);
		hv_store_ent(srv, key_priority, priority, 0);
		hv_store_ent(srv, key_weight, weight, 0);
		hv_store_ent(srv, key_port, port, 0);

		srv_addrs = newAV();
		srv_addrs_ref = newRV_inc((SV*) srv_addrs);
		hv_store_ent(srv, key_addr_list, srv_addrs_ref, 0);

		for (j = 0; j < addr_list_size; ++j) {
			ruli_addr_t *addr = ruli_list_get(addr_list, j);
			push_ruli_addr(srv_addrs, addr);
		}
	}

	ruli_sync_delete(sync_query);

	RETVAL = srv_array_ref;
#line 258 "RULI.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_RULI_ruli_sync_smtp_query); /* prototype to pass -Wmissing-prototypes */
XS(XS_RULI_ruli_sync_smtp_query)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RULI::ruli_sync_smtp_query(domain, options)");
    {
	const char *	domain = (const char *)SvPV_nolen(ST(0));
	long	options = (long)SvIV(ST(1));
	SV *	RETVAL;
#line 150 "RULI.xs"
	ruli_sync_t *sync_query;
	int srv_code;
	ruli_list_t *srv_list;
	int srv_list_size;
	int i;
        AV* srv_array;
        SV* srv_array_ref;
	const char *label_target    = "target";
	const char *label_priority  = "priority";
	const char *label_weight    = "weight";
	const char *label_port      = "port";
	const char *label_addr_list = "addr_list";
	SV* key_target    = newSVpv(label_target,    strlen(label_target));
	SV* key_priority  = newSVpv(label_priority,  strlen(label_priority));
	SV* key_weight    = newSVpv(label_weight,    strlen(label_weight));
	SV* key_port      = newSVpv(label_port,      strlen(label_port));
	SV* key_addr_list = newSVpv(label_addr_list, strlen(label_addr_list));

	/* Submit query */
	sync_query =ruli_sync_smtp_query(domain, options);
	if (!sync_query)
		XSRETURN_UNDEF;

	/* Underlying SRV query failure? */
	srv_code = ruli_sync_srv_code(sync_query);
	if (srv_code == RULI_SRV_CODE_ALARM) {
		ruli_sync_delete(sync_query);
		XSRETURN_UNDEF;
	}

	/* Service provided? */
	if (srv_code == RULI_SRV_CODE_UNAVAILABLE) {
		ruli_sync_delete(sync_query);
		XSRETURN_UNDEF;
	}

	/* Server RCODE? */
	if (srv_code) {
		int rcode = ruli_sync_rcode(sync_query);
		if (rcode) {
			ruli_sync_delete(sync_query);
			XSRETURN_UNDEF;
		}

		ruli_sync_delete(sync_query);
		XSRETURN_UNDEF;
	}

	srv_list = ruli_sync_srv_list(sync_query);
	srv_list_size = ruli_list_size(srv_list);

	srv_array = newAV();
	srv_array_ref = newRV_inc((SV*) srv_array);

	/* Scan list of SRV records */
	for (i = 0; i < srv_list_size; ++i) {
		ruli_srv_entry_t *entry         = ruli_list_get(srv_list, i);
		ruli_list_t      *addr_list     = &entry->addr_list;
		int              addr_list_size = ruli_list_size(addr_list);
		char             txt_dname_buf[RULI_LIMIT_DNAME_TEXT_BUFSZ];
		int              txt_dname_len;
		int              j;

		HV*	srv;
		SV*	srv_ref;
		SV*	target;
		SV*	priority;
		SV*	weight;
		SV*	port;
		AV*	srv_addrs;
		SV*	srv_addrs_ref;

		if (ruli_dname_decode(txt_dname_buf, 
			RULI_LIMIT_DNAME_TEXT_BUFSZ,
	       		&txt_dname_len,
			entry->target, entry->target_len))
			continue;

		target   = newSVpv(txt_dname_buf, txt_dname_len);
		priority = newSViv(entry->priority);
		weight   = newSViv(entry->weight);
		port     = newSViv(entry->port);

		srv = newHV();
		srv_ref = newRV_inc((SV*) srv);
		av_push(srv_array, srv_ref);

		hv_store_ent(srv, key_target, target, 0);
		hv_store_ent(srv, key_priority, priority, 0);
		hv_store_ent(srv, key_weight, weight, 0);
		hv_store_ent(srv, key_port, port, 0);

		srv_addrs = newAV();
		srv_addrs_ref = newRV_inc((SV*) srv_addrs);
		hv_store_ent(srv, key_addr_list, srv_addrs_ref, 0);

		for (j = 0; j < addr_list_size; ++j) {
			ruli_addr_t *addr = ruli_list_get(addr_list, j);
			push_ruli_addr(srv_addrs, addr);
		}
	}

	ruli_sync_delete(sync_query);

	RETVAL = srv_array_ref;
#line 381 "RULI.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_RULI); /* prototype to pass -Wmissing-prototypes */
XS(boot_RULI)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("RULI::constant", XS_RULI_constant, file);
        newXSproto("RULI::ruli_sync_query", XS_RULI_ruli_sync_query, file, "$$$$");
        newXSproto("RULI::ruli_sync_smtp_query", XS_RULI_ruli_sync_smtp_query, file, "$$");
    XSRETURN_YES;
}

