
package ruli.sample;

import java.util.Map;

import ruli.RuliSync;

public class RuliSyncSrvSearch {
    
    private static void usage() {
	System.err.println("usage:   RuliSyncSrvSearch service domain [fallbackport] [options]");
	System.err.println("example: RuliSyncSrvSearch _http._tcp web-domain.tld");
	System.exit(1);
    }

    public static void main(String[] args) {

	if ((args.length < 2) || (args.length > 4))
	    usage();

	String service = args[0];
	String domain = args[1];
	int fallbackPort = (args.length > 2) ? Integer.parseInt(args[2]) : -1;
	int options = (args.length > 3) ? Integer.parseInt(args[3]) : 0;

	Map[] srvList = RuliSync.srvQuery(service, domain, 
					  fallbackPort, options);

	System.out.println(service + "." + domain);

	for (int i = 0; i < srvList.length; ++i) {
	    Map m = srvList[i];
	    String target = (String) m.get("target");
	    int priority = ((Integer) m.get("priority")).intValue();
	    int weight = ((Integer) m.get("weight")).intValue();
	    int port = ((Integer) m.get("port")).intValue();

	    System.out.print("  target=" + target + " priority=" + priority + " weight=" + weight + " port=" + port + " addresses=");
	    
	    String[] addrList = (String[]) m.get("addresses");
	    for (int j = 0; j < addrList.length; ++j) {
		System.out.print(addrList[j] + " ");
	    }
	    
	    System.out.println();
	}

    }

}
