CREATE TABLE resource (
	id SERIAL PRIMARY KEY,
	nr INTEGER,

	rdfs_label TEXT,
	comment TEXT,
	publisher INTEGER,
	publishDate DATE,

	literal BOOLEAN DEFAULT false,
	uriref BOOLEAN DEFAULT false,
	label TEXT);

INSERT INTO resource (nr, rdfs_label, comment, publisher, publishDate, label)
	SELECT nr, label, comment, publisher, publishDate, 'productfeature' FROM productfeature;
ALTER TABLE productfeature
	ADD id INTEGER, DROP label, DROP comment, DROP publisher, DROP publishDate;
UPDATE productfeature AS pf SET id = r.id
	FROM resource AS r WHERE r.nr = pf.nr;
UPDATE resource SET nr = null;
ALTER TABLE productfeature ADD PRIMARY KEY (id), ADD UNIQUE (nr);

INSERT INTO resource (nr, rdfs_label, comment, publisher, publishDate, label)
	SELECT nr, label, comment, publisher, publishDate, 'producttype' FROM producttype;
ALTER TABLE producttype
	ADD id INTEGER, DROP label, DROP comment, DROP publisher, DROP publishDate;
UPDATE producttype AS pf SET id = r.id
	FROM resource AS r WHERE r.nr = pf.nr;
UPDATE resource SET nr = null;
ALTER TABLE producttype ADD PRIMARY KEY (id), ADD UNIQUE (nr);
UPDATE producttype AS pf SET parent = pf_parent.id
	FROM producttype AS pf_parent WHERE pf_parent.nr = pf.parent;

INSERT INTO resource (nr, rdfs_label, comment, publisher, publishDate, label)
	SELECT nr, label, comment, publisher, publishDate, 'producer' FROM producer;
ALTER TABLE producer
	ADD id INTEGER, DROP label, DROP comment, DROP publisher, DROP publishDate;
UPDATE producer AS p SET id = r.id
	FROM resource AS r WHERE r.nr = p.nr;
UPDATE resource SET nr = null;
ALTER TABLE producer ADD PRIMARY KEY (id), ADD UNIQUE (nr);

INSERT INTO resource (nr, rdfs_label, comment, publisher, publishDate, label)
	SELECT nr, label, comment, publisher, publishDate, 'product' FROM product;
ALTER TABLE product
	ADD id INTEGER, DROP label, DROP comment, DROP publisher, DROP publishDate;
UPDATE product AS p SET id = r.id
	FROM resource AS r WHERE r.nr = p.nr;
UPDATE resource SET nr = null;
ALTER TABLE product ADD PRIMARY KEY (id), ADD UNIQUE (nr);
UPDATE product SET producer = producer.id
	FROM producer WHERE product.producer = producer.nr;
UPDATE resource SET publisher = product.producer
	FROM product WHERE product.id = resource.id;
CREATE INDEX product_producer_idx ON product (producer);
CREATE INDEX product_properties_index ON product (
	propertynum1, propertynum2, propertynum3,
	propertynum4, propertynum5, propertynum6);

ALTER TABLE producttypeproduct ADD id INTEGER;
UPDATE producttypeproduct AS ptp SET id = p.id, productType = pt.id
	FROM product AS p, producttype AS pt
	WHERE ptp.product = p.nr AND ptp.productType = pt.nr;
ALTER TABLE producttypeproduct
	DROP product, ADD PRIMARY KEY (id, productType);
CREATE INDEX producttypeproduct_producttype_id_idx
	ON producttypeproduct (productType, id);

ALTER TABLE productfeatureproduct ADD id INTEGER;
UPDATE productfeatureproduct AS pfp SET id = p.id, productFeature = pf.id
	FROM product AS p, productfeature AS pf
	WHERE pfp.product = p.nr AND pfp.productFeature = pf.nr;
ALTER TABLE productfeatureproduct
	DROP product, ADD PRIMARY KEY (id, productFeature);
CREATE INDEX productfeatureproduct_productfeature_id_idx
	ON productfeatureproduct (productFeature, id);

INSERT INTO resource (nr, rdfs_label, comment, publisher, publishDate, label)
	SELECT nr, label, comment, publisher, publishDate, 'vendor' FROM vendor;
ALTER TABLE vendor
	ADD id INTEGER, DROP label, DROP comment, DROP publisher, DROP publishDate;
UPDATE vendor AS v SET id = r.id
	FROM resource AS r WHERE r.nr = v.nr;
UPDATE resource SET nr = null;
ALTER TABLE vendor ADD PRIMARY KEY (id), ADD UNIQUE (nr);

INSERT INTO resource (nr, publisher, publishDate, label)
	SELECT nr, publisher, publishDate, 'offer' FROM offer;
ALTER TABLE offer
	ADD id INTEGER, DROP publisher, DROP publishDate;
UPDATE offer AS o SET id = r.id
	FROM resource AS r WHERE r.nr = o.nr;
UPDATE resource SET nr = null;
ALTER TABLE offer ADD PRIMARY KEY (id), ADD UNIQUE (nr);
UPDATE offer AS o
	SET product = p.id, producer = pr.id, vendor = v.id
	FROM product AS p, producer AS pr, vendor AS v
	WHERE o.product = p.nr AND o.producer = pr.nr AND o.vendor = v.nr;
UPDATE resource SET publisher = offer.vendor
	FROM offer WHERE offer.id = resource.id;
CREATE INDEX offer_product_idx ON offer (product);
CREATE INDEX offer_vendor_idx ON offer (vendor);
CREATE INDEX offer_product_validto_idx ON offer (product, validto);
CREATE INDEX offer_product_deliverydays_validto_idx
	ON offer (product, deliveryDays, validTo);

INSERT INTO resource (nr, publisher, publishDate, label)
	SELECT nr, publisher, publishDate, 'person' FROM person;
ALTER TABLE person
	ADD id INTEGER, DROP publisher, DROP publishDate;
UPDATE person AS p SET id = r.id
	FROM resource AS r WHERE r.nr = p.nr;
UPDATE resource SET nr = null;
ALTER TABLE person ADD PRIMARY KEY (id), ADD UNIQUE (nr);

INSERT INTO resource (nr, publisher, publishDate, label)
	SELECT nr, publisher, publishDate, 'review' FROM review;
ALTER TABLE review
	ADD id INTEGER, DROP publisher, DROP publishDate;
UPDATE review AS rv SET id = r.id
	FROM resource AS r WHERE r.nr = rv.nr;
UPDATE resource SET nr = null;
ALTER TABLE review ADD PRIMARY KEY (id), ADD UNIQUE (nr);
UPDATE review AS rv SET person = ps.id, product = p.id, producer = pr.id
	FROM person AS ps, product AS p, producer AS pr
	WHERE rv.person = ps.nr AND rv.product = p.nr AND rv.producer = pr.nr;
CREATE INDEX review_product_idx ON review (product);
CREATE INDEX review_person_idx ON review (person);
CREATE INDEX review_product_person_idx ON review (product, person);

ALTER TABLE resource DROP nr;
ALTER TABLE productfeature DROP nr;
ALTER TABLE producttype DROP nr;
ALTER TABLE producer DROP nr;
ALTER TABLE product DROP nr;
ALTER TABLE vendor DROP nr;
ALTER TABLE offer DROP nr;
ALTER TABLE person DROP nr;
ALTER TABLE review DROP nr;

CREATE INDEX resource_uriref_idx ON Resource (uriref);
CREATE INDEX resource_label_idx ON Resource (label);
CREATE INDEX resource_rdfs_label_ts_idx ON resource USING gin(to_tsvector('simple', rdfs_label));

CREATE TABLE producttypeproduct_tc (
	id INTEGER,
	productType INTEGER,
	PRIMARY KEY (id, productType)
);
INSERT INTO producttypeproduct_tc
WITH RECURSIVE parent_product_type (product, type, parent) AS (
	SELECT ptp.id, pt.id, pt.parent
	FROM producttypeproduct ptp
	INNER JOIN producttype pt ON pt.id = ptp.productType
UNION ALL
	SELECT ppt.product, pt.id, pt.parent
	FROM parent_product_type ppt
	INNER JOIN producttype pt ON pt.id = ppt.parent
)
SELECT product, type
FROM parent_product_type;
CREATE INDEX producttypeproduct_tc_producttype_id_idx
	ON producttypeproduct_tc (productType, id);

VACUUM ANALYZE;
