-- Samizdat Database Triggers - PostgreSQL
--
--   Copyright (c) 2002-2009  Dmitry Borodaenko <angdraug@debian.org>
--
--   This program is free software.
--   You can distribute/modify this program under the terms of
--   the GNU General Public License version 3 or later.
--

CREATE FUNCTION insert_resource() RETURNS TRIGGER AS $$
    BEGIN
        IF NEW.id IS NULL THEN
            INSERT INTO Resource (literal, uriref, label)
                VALUES ('false', 'false', TG_ARGV[0]);
            NEW.id := currval('resource_id_seq');
        END IF;
        RETURN NEW;
    END;
$$ LANGUAGE 'plpgsql';

CREATE TRIGGER insert_member BEFORE INSERT ON productfeature
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('productfeature');

CREATE TRIGGER insert_message BEFORE INSERT ON producttype
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('producttype');

CREATE TRIGGER insert_vote BEFORE INSERT ON producer
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('producer');

CREATE TRIGGER insert_item BEFORE INSERT ON product
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('product');

CREATE TRIGGER insert_possession BEFORE INSERT ON vendor
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('vendor');

CREATE TRIGGER insert_event BEFORE INSERT ON offer
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('offer');

CREATE TRIGGER insert_recurrence BEFORE INSERT ON person
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('person');

CREATE TRIGGER insert_recurrence BEFORE INSERT ON review
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('review');

CREATE FUNCTION delete_resource() RETURNS TRIGGER AS $$
    BEGIN
        DELETE FROM Resource WHERE id = OLD.id;
        RETURN NULL;
    END;
$$ LANGUAGE 'plpgsql';

CREATE TRIGGER delete_statement AFTER DELETE ON productfeature
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_member AFTER DELETE ON producttype
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_message AFTER DELETE ON producer
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_vote AFTER DELETE ON product
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_item AFTER DELETE ON vendor
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_possession AFTER DELETE ON offer
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_event AFTER DELETE ON review
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();
