#!/usr/bin/env ruby
#
# Samizdat front page
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

session = Session.new

session.response do |t|
    set_lang, = session.params %w[set_lang]
    if set_lang then
        session.set_cookie('lang', set_lang)
        session.redirect
    end

    skip, skip_focus = session.params %w[skip skip_focus]
    skip = skip.to_i
    skip_focus = skip_focus.to_i

    messages = session.rdf.select_all( %{
SELECT ?msg
WHERE (dc::date ?msg ?date)
      (s::thread ?msg ?msg)
ORDER BY ?date DESC
USING PRESET NS}, limit_page, limit_page * skip
    ).collect {|msg,| Resource.new(session, msg).render }

    page = [ [ _('Recent Updates') +
            (skip > 0? sprintf(_(', page %s'), skip + 1) : ''),
        t.list(messages, t.nav(skip + 1)) ] ]

    table = session.rdf.select_all( %{
SELECT ?focus, count(?resource)
WHERE (rdf::predicate ?stmt dc::relation)
      (rdf::subject ?stmt ?resource)
      (rdf::object ?stmt ?focus)
      (s::rating ?stmt ?rating)
LITERAL ?rating > 0
GROUP BY ?focus
ORDER BY count(?resource) DESC
USING PRESET NS}, limit_page, limit_page * skip_focus
    ).collect {|focus, usage| [ Resource.new(session, focus).render, usage ] }

    page << [ _('Important Focuses') +
            (skip_focus > 0? sprintf(_(', page %s'), skip_focus + 1) : ''),
        t.table([[_('Focus'), _('Related Resources')]] + table,
            t.nav(skip_focus + 1, 'index.rb?', 'skip_focus')) ]

    side = ''
    if defined?(GetText) then   # add language selection box
        old_language = session.language
        list = ''
        config['locale']['languages'].each do |lang|
            lang.untaint
            session.language = lang
            list += %{<a href="index.rb?set_lang=#{lang}">} +
                _('English') + "</a>\n"
        end
        session.language = old_language
        side = t.box(_('Interface Language'), list)
    end

    t.page(_('Front Page'), page, side)
end
