#!/usr/bin/env ruby
#
# Samizdat member registration and preferences
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

session = Session.new

session.response do |t|

    # account settings
    login, full_name, email, passwd1, passwd2 = \
        session.params %w[login full_name email passwd1 passwd2]

    # validate password
    raise UserError, _('Passwords do not match') if
        passwd1 != passwd2

    title = session.id ? _('Change Account Settings') : _('Create New Account')

    if session.has_key? 'submit' then
db.transaction do |db|   # AutoCommit assumed off
        if full_name then   # check for duplicate full_name
            if session.id then
                id, = db.select_one(
                    'SELECT id FROM Member WHERE full_name = ? AND id != ?',
                    full_name, session.id)
            else
                id, = db.select_one(
                    'SELECT id FROM Member WHERE full_name = ?', full_name)
            end
            id.nil? or raise UserError,
                _('Full name you specified is used by someone else')
        end

        if session.id then   # change existing account
            if full_name and full_name != session.full_name then
                db.do 'UPDATE Member SET full_name = ? WHERE id = ?',
                    full_name, session.id
            end
            if email and email != session.email then   # todo: validate email
                db.do 'UPDATE Member SET email = ? WHERE id = ?',
                    email, session.id
            end
            if passwd1 then
                require 'digest/md5'
                db.do 'UPDATE Member SET passwd = ? WHERE id = ?',
                    Digest::MD5.new(passwd1).hexdigest, session.id
            end
            title = _('Changes Accepted')

        else   # create new account
            # validate form
            (login and full_name and email and passwd1) or raise UserError,
                _("You didn't fill all mandatory fields")
            login == 'pingback' and raise UserError,
                _('Login name you specified is reserved for Pingback server')
            login =~ /[^a-zA-Z0-9]/ and raise UserError,
                _('Use only latin letters and numbers in login name')
            id, = db.select_one 'SELECT id FROM Member WHERE login = ?', login
            id.nil? or raise UserError,
                _('Login name you specified is already used by someone else')

            # create account
            require 'digest/md5'
            db.do 'INSERT INTO Member (login, full_name, email, passwd)
                VALUES (?, ?, ?, ?)',
                login, full_name, email, Digest::MD5.new(passwd1).hexdigest
            db.commit
            session.open(login, passwd1) or raise RuntimeError,
                _('Login error: failed to open session for new account')
        end
end # transaction
    end

    if session.id then   # change existing account
        form = []
        full_name = session.full_name unless full_name
        email = session.email unless email
    else   # new account
        form = [[:label, 'login', _('Login')], [:text, 'login', login]]
    end

    form.push(
        [:label, 'full_name', _('Full name')], [:text, 'full_name', full_name],
        [:label, 'email', _('Email')], [:text, 'email', email],
        [:label, 'passwd1', _('Password')], [:password, 'passwd1'],
        [:label, 'passwd2', _('Reenter password to confirm')],
            [:password, 'passwd2'],
        [:label], [:submit, 'submit']
    )

    t.page(title, t.form('member.rb', *form))
end
