#!/usr/bin/env ruby
#
# Samizdat resource display
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

session = Session.new

session.response do |t|
    set_focus, = session.params %w[set_focus]
    if set_focus.to_i > 0 then   # set current focus
        session.set_cookie('focus', set_focus)
        session.redirect
    end

    # RewriteRule ^(/samizdat-base)/([0-9]+)$ $1/resource.rb?id=$2 [PT]
    #
    id, = session.params %w[id]
    id.nil? and raise ResourceNotFoundError,
        sprintf(_("Incorrect resource id '%s'"), id)

    # render resource
    resource = Resource.new(session, id)
    type, head, description = resource.render(:full)

    # related resources
    skip, = session.params %w[skip_related]
    skip = skip.to_i
    resources = session.rdf.select_all( %{
SELECT ?msg
WHERE (rdf::subject ?stmt ?msg)
      (rdf::predicate ?stmt dc::relation)
      (rdf::object ?stmt #{session.base}#{id})
      (s::thread ?msg ?msg)
      (s::rating ?stmt ?rating)
      (dc::date ?msg ?date)
LITERAL ?rating > 0
ORDER BY ?date DESC
USING PRESET NS}, limit_page, limit_page * skip
    ).collect {|msg,| Resource.new(session, msg).render }
    if resources.size > 0 then
        type = 'Focus'
        head = _(head)   # translate focus names
        page = [ [ _('Focus') + ' / ' + head + ' / ' + _('Recent Updates') +
                (skip > 0? sprintf(_(', page %s'), skip + 1) : ''),
            t.list(resources,
                t.nav(skip + 1, "resource.rb?id=#{id}&amp;", 'skip_related'))
        ] ]
    else page = []
    end

    # main part
    title = _(type) + ' / ' + head
    page << [ title, description ]

    # current focus
    focus = Focus.new(resource)
    page << [ _('Your Current Focus'),
        t.box(nil, focus.render) + t.box(nil,
            %{<p><a href="resource.rb?set_focus=#{id}">} +
            _('Focus on this resource') + %{ (#{head})</a></p>}) ]

    # related focuses
    focuses = {focus.id => focus}
    (
        session.rdf.select_all( %{
SELECT ?focus
WHERE (rdf::subject ?stmt #{session.base}#{id})
      (rdf::predicate ?stmt dc::relation)
      (rdf::object ?stmt ?focus)
      (s::rating ?stmt ?rating)
ORDER BY ?rating DESC
USING PRESET NS}, limit_page
        ).collect {|f,| f } + config['focus']   # add standard focuses
    ).each {|focus|
        f = Focus.new(resource, focus)
        focuses[f.id] = f
    }

    # vote on focus rating
    if session.has_key? 'related' then
        session.id.nil? and raise AuthError,
            _('You should be logged in to vote')

        focus = Focus.new(resource, session['related'])
        focus.uriref == resource.uriref and
            raise UserError, _("You can't relate resource to itself")

        rating, = session.params %w[rating]
        if rating then   # commit vote
            focus.rating = rating
            session.redirect
        else   # display vote form
            vote = t.vote_box(focus)
        end
    end

    session.options['x-pingback'] = session.base + 'pingback.rb' if
        config['pingback']['login']

    t.page(title, page, t.focus_box(id, focuses.values) + vote.to_s)
end
