#!/usr/bin/env ruby
#
# Samizdat test suite utility methods
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'rexml/document'

def elements(element, xpath, attribute=nil)
    element.elements.to_a(xpath).collect {|e|
        attribute ? e.attributes[attribute] : e.text.strip
    }
end

def text(element, xpath)
    element.elements[xpath].texts.join.strip
end

def parse(html)
    begin
        doc = REXML::Document.new(html)
    rescue REXML::ParseException
        assert false, "REXML raised #{$!.class}: #{$!}"
    end
    doc.root
end
