#!/usr/bin/env ruby
#
# Samizdat message history
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

request do |session|
    id, old, new = session.params %w[id old new]
    t = session.template
    if id then   # history table
        skip, = session.params %w[skip]
        skip = skip.to_i

        type, head = Resource.new(session, id).render(:short)
        title = _(type) + ' / ' + head + ' / ' + _('History of Changes') +
            (skip > 0? sprintf(_(', page %s'), skip + 1) : '')

        # current version
        versions = (skip > 0? [] : [ id ])

        # previous versions
        rdf.select_all(%{
SELECT ?version
WHERE (dct::isVersionOf ?version #{id})
      (dc::date ?version ?date)
ORDER BY ?date DESC
USING PRESET NS},
            limit_page - versions.size + 1, limit_page * skip - 1
        ).each {|version,| versions.push version }
        last = versions.pop if versions.size == limit_page + 1

        # table of changes
        compare = _('compare with previous version')
        0.upto(versions.size - 1) do |i|
            diff = nil
            diff = %{<a href="history.rb?old=#{versions[i+1]}&new=#{versions[i]}">#{compare}</a>} if i < versions.size - 1
            # offer diff for last on page if not last in history
            diff = %{<a href="history.rb?old=#{last}&new=#{versions[i]}">#{compare}</a>} if diff.nil? and last
            versions[i] = [ Resource.new(session, versions[i]).render, diff ]
        end

        page = t.table([[_('Versions'), _('Changes')]] + versions,
            t.nav(skip + 1, "history.rb?id=#{id}&amp;"))

    else   # difference engine
        old, new = old.to_i, new.to_i
        raise UserError, _('Bad input') unless old > 0 and new > 0

        ro = Resource.new(session, old)
        rn = Resource.new(session, new)
        to, = ro.render(:short)
        type, head = rn.render(:short)
        raise UserError, _('Bad input') unless
            'Message' == to and 'Message' == type
        title = _(type) + ' / ' + head + ' / ' + _('Changes')

        fo, = rdf.select_one "
SELECT ?format WHERE (dc::format #{old} ?format) USING PRESET NS"
        co, = rdf.select_one "
SELECT ?content WHERE (s::content #{old} ?content) USING PRESET NS"
        fn, = rdf.select_one "
SELECT ?format WHERE (dc::format #{new} ?format) USING PRESET NS"
        cn, = rdf.select_one "
SELECT ?content WHERE (s::content #{new} ?content) USING PRESET NS"

        page = t.diff({:info => ro.render, :format => fo, :content => co},
            {:info => rn.render, :format => fn, :content => cn})
    end

    t.page(title, page)
end
