#!/usr/bin/env ruby
#
# Samizdat resource display
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

request do |session|
    set_focus, = session.params %w[set_focus]
    if set_focus.to_i > 0 then   # set current focus
        session.set_cookie('focus', set_focus)
        session.redirect
    end

    # RewriteRule ^(/samizdat-base)/([0-9]+)$ $1/resource.rb?id=$2 [PT]
    #
    id, = session.params %w[id]
    id.nil? and raise ResourceNotFoundError,
        sprintf(_("Incorrect resource id '%s'"), id)

    # render resource
    t = session.template
    resource = Resource.new(session, id)
    r = resource.render(session.has_key?('related')? :short : :full)
    type, head, desc = r[:type], r[:head], r.to_s
    title = _(type) + ' / ' + head

    # vote on focus rating
    if session.has_key? 'related' then
        session.id.nil? and raise AuthError,
            _('You should be <a href="login.rb">logged in</a> to vote')

        focus = Focus.new(resource, session['related'])
        focus.uriref == resource.uriref and
            raise UserError, _("You can't relate resource to itself")

        rating, = session.params %w[rating]
        if rating then   # commit vote
            focus.rating = rating
            session.redirect(id.to_s)
        else   # display vote form
            next t.page(title + ' / ' + _('Vote'),
                [[_('Vote'), t.vote_form(focus)], [title, desc]])
        end
    end

    # related resources
    skip, = session.params %w[skip_related]
    skip = skip.to_i
    resources = rdf.select_all( %{
SELECT ?msg
WHERE (rdf::subject ?stmt ?msg)
      (rdf::predicate ?stmt dc::relation)
      (rdf::object ?stmt #{id})
      (s::inReplyTo ?msg ?parent)
      (dct::isVersionOf ?msg ?current)
      (s::rating ?stmt ?rating)
      (dc::date ?msg ?date)
LITERAL ?rating > 0 AND ?parent IS NULL AND ?current IS NULL
ORDER BY ?date DESC
USING PRESET NS}, limit_page, limit_page * skip
    ).collect {|msg,| Resource.new(session, msg).render(:short)[:desc] }
    if resources.size > 0 then
        head = _(head)   # translate focus names
        page = [ [ _('Focus') + ' / ' + head + ' / ' + _('Recent Updates') +
                (skip > 0? sprintf(_(', page %s'), skip + 1) : ''),
            t.list(resources,
                t.nav(skip + 1, "resource.rb?id=#{id}&amp;", 'skip_related'))
        ] ]
    else page = []
    end

    session.options['x-pingback'] = session.base + 'pingback.rb' if
        config['pingback']['login']
    t.page(title, page << [ title, desc ])
end
