-- Samizdat Database Triggers
--
--   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
--
--   This program is free software.
--   You can distribute/modify this program under the terms of
--   the GNU General Public License version 2 or later.
--

CREATE FUNCTION insert_resource() RETURNS OPAQUE AS '
    BEGIN
	IF NEW.id IS NULL THEN
	    INSERT INTO Resource (literal, uriref, label)
	        VALUES (''false'', ''false'', TG_ARGV[0]);
	    NEW.id := currval(''Resource_id_seq'');
	END IF;
	RETURN NEW;
    END;
' LANGUAGE 'plpgsql';

CREATE TRIGGER insert_statement BEFORE INSERT ON Statement
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('Statement');

CREATE TRIGGER insert_member BEFORE INSERT ON Member
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('Member');

CREATE TRIGGER insert_message BEFORE INSERT ON Message
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('Message');

CREATE TRIGGER insert_vote BEFORE INSERT ON Vote
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('Vote');

CREATE TRIGGER insert_item BEFORE INSERT ON Item
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('Item');

CREATE TRIGGER insert_possession BEFORE INSERT ON Possession
    FOR EACH ROW EXECUTE PROCEDURE insert_resource('Possession');

CREATE FUNCTION delete_resource() RETURNS OPAQUE AS '
    BEGIN
	DELETE FROM Resource WHERE id = OLD.id;
	RETURN NULL;
    END;
' LANGUAGE 'plpgsql';

CREATE TRIGGER delete_statement AFTER DELETE ON Statement
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_member AFTER DELETE ON Member
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_message AFTER DELETE ON Message
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_vote AFTER DELETE ON Vote
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_item AFTER DELETE ON Item
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE TRIGGER delete_possession AFTER DELETE ON Possession
    FOR EACH ROW EXECUTE PROCEDURE delete_resource();

CREATE FUNCTION update_rating() RETURNS OPAQUE AS '
    BEGIN
        UPDATE Statement SET rating = (SELECT AVG(rating) FROM Vote
	    WHERE proposition = NEW.proposition) WHERE id = NEW.proposition;
	RETURN NEW;
    END;
' LANGUAGE 'plpgsql';


CREATE TRIGGER update_rating AFTER INSERT OR UPDATE ON Vote
    FOR EACH ROW EXECUTE PROCEDURE update_rating();
