#!/usr/bin/env ruby
#
# Samizdat member login
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

request do |session|
    login, passwd = session.params %w[login passwd]

    if login and passwd then
        session.open login, passwd
    else
        t = session.template
        t.page( _('Log in'), '<p>'+_('Use existing account:')+'</p>' +
            t.form( 'login.rb',
                [:label, 'login', _('Login')],
                [:text, 'login'],
                [:label, 'passwd', _('Password')],
                [:password, 'passwd'],
                [:label],
                [:submit]
            ) + '<p><a href="member.rb">'+_('Create New Account')+'</a></p>' +
            ( config['email'] ?
'<p><a href="member.rb?recover">'+_('Recover Lost Password')+'</a></p>' : ''
            )
        )
    end
end
