# Samizdat view management class
#
#   Copyright (c) 2002-2009  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 3 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'
require 'erb'

class View

  def initialize(template)
    location = find_file(template, config['templates'])
    location or raise RuntimeError,
      "Template not found: '#{CGI.escapeHTML(template)}'"
    body = File.open(location) {|f| f.read }
    @template = ERB.new(body.untaint, nil, '>')
  end

  attr_reader :template

  # returns a cached ERB object
  #
  def View.cached(template)
    local_cache.fetch_or_add('template/' + template) do
      View.new(template).template
    end
  end

  # render the +template+ in the context of +controller+
  #
  def View.render(controller, template)
    View.cached(template).result(controller.instance_eval('binding'))
  end
end
