;; -*- emacs-lisp -*-
;; Part of GNU Savannah
;; Savannah moderation related functions
;; Copyright 2002-2003 (c) Mathieu Roy <yeupou@gnu.org>
;;                     (c) Jaime Villate <villate@gnu.org>
;;                     (c) Rudy Gevaert <rudy@gnu.org>
;; http://savannah.gnu.org
;;
;;   This program is free software; you can redistribute it and/or
;;   modify it under the terms of the GNU General Public License
;;   as published by the Free Software Foundation; either version 2
;;   of the License, or (at your option) any later version.
;;
;;   This program is distributed in the hope that it will be useful,
;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;   GNU General Public License for more details.
;;
;;   You should have received a copy of the GNU General Public License
;;   along with this program; if not, write to the Free Software
;;   Foundation, Inc., 59 Temple Place
;;   Suite 330, Boston, MA  02111-1307, USA.
;;
;; HELP:
;;   Add this file to your GNU Emacs elisp path and add the following
;;   line to your ~/.emacs
;;     (require `savannah)
;;       or
;;     (autoload 'savannah "/home/vrac/savannah/gnuscripts/savannah.el")
;;   After that, you can access these functions by typing
;;     META-x sv-prefix-[TAB]
;;   Where prefix can be:
;;     opening 
;;     closing
;;     problem (several common problems in registrations)
;;     reject
;;     approve
;;     dead (projects that seem to be dead)
;;     term (can be used to do SQL commands with ease,
;;           typing them within an eshell or another shell in emacs.
;;           Their names should be self-explanatory.)
;;
;; Projects that are not ready to be approved are usually answered with:
;;
;;    sv-opening
;;    sv-problem-[problem1] ... sv-problem-[problem2]
;;    sv-closing
;;
;; AUTHORS:
;;
;;   Loic Dachary, Jaime Villate and Mathieu Roy. There are some quotes
;;   from www.gnu.org as the license list page.  Rudy Gevaert imported
;;   the changes that Paul A. Crable suggested and added the sections
;;   about the LGPL.
;;
;; $Id: savannah.el,v 1.9 2004/01/30 23:00:05 yeupou Exp $

;; GENERAL

(defun sv-opening ()
  (interactive)
  "Message opening"
  (insert "Hi,\n
I'm evaluating the project you submitted for approval in Savannah.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-closing ()
  (interactive)
  "End of the message"
  (insert "Please register your project once more with the changes
mentioned above.  

We cannot track projects that have been answered but not approved, so
we must ask you to register the project whenever you change the
registration. Make sure to apply all changes so you need to reregister
only once.

The re-registration URL found in our acknowledgement of your earlier
registration will direct you to the proper location.

Regards,\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-closing-no-resubmit ()
  (interactive)
  "End of the message, do not ask to resubmit--Nothing of use here"
  (insert "Regards,\n\n")
  (message "Inserted \(savannah.el\)")
  )

;; PROBLEMS IN THE REGISTRATION

(defun sv-problem-details ()
  (interactive)
  "The description of your project is too vague"
  (insert "Please resubmit your project with a detailed technical
description that specifies such requirements as programming languages
and external libraries.  It should be at least one-half a page.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-tarball ()
  (interactive)
  "There's no tarball in the registration text"
  (insert "Please register your project again and include an (temporary) URL
pointing to the source code.  The description you gave when
registering will not be read by the general public. If you are still
concerned with privacy, however, you can forward the code to me by
email.

We wish to review your source code, even if it is not functional, to
catch potential legal issues early.  

For example, to release your program properly under the GPL you must
include a copyright notice and statement permitting copying at the
beginning of every file of source code.  This is explained in
http://www.gnu.org/licenses/gpl-howto.html.  Our review would help
catch potential omissions such as these.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-gpl-info ()
  (interactive)
  "License stuff is missing"
  (insert "Before releasing your project under the GPL, please place
copyright notices and permission to copy statements at the beginning
of every file of source code.  

In addition, if you haven't already, please copy a copy of the plain
text version of the GPL, available from
\(http://www.gnu.org/licenses/gpl.txt\), into a file named \"COPYING\".

Additional instructions are available from
http://www.gnu.org/licenses/gpl-howto.html.

The GPL FAQ explains why these procedures must be followed.  To learn
why a copy of the GPL must be included with every copy of the code,
for example, go to
http://www.gnu.org/licenses/gpl-faq.html#WhyMustIInclude\n")
  (message "Inserted \(savannah.el\)")
  )


(defun sv-problem-lgpl-info ()
  (interactive)
  "License stuff is missing"
  (insert "Before releasing your project under the LGPL, please place
copyright notices and permission to copy statements at the beginning
of every file of source code.  In addition, please copy a copy of the
plain text version of the LGPL, available from
http://www.gnu.org/licenses/gpl.txt into a file named \"COPYING\".

For further instructions, go to
http://www.gnu.org/licenses/lgpl.html#SEC4 \n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-fsf-address ()
  (interactive)
  "Old FSF address used"
  (insert "The address of the FSF has changed, and is now:

  59 Temple Place, Suite 330
  Boston, MA  02111-1307
  USA

Please update your files.  \n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-license-truncated ()
  (interactive)
  "The last section of the license has been truncated"
  (insert "The license does not contain the last section, titled
\"How to Apply These Terms to Your New Programs\".  

Please use a complete verbatim copy of the license, which may be found
at http://www.gnu.org/licenses/gpl.txt,
http://www.gnu.org/licenses/lgpl.txt or
http://www.gnu.org/licenses/fdl.txt 

The license must be copied verbatim and in its entirety.  \n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-java ()
  (interactive)
  "We need to check Java code for ugly dependencies"
  (insert "You must determine whether your project can run on a Free
Software Java suite \(see http://www.gnu.org/software/java/ for more
information\).  

Please provide us more information about this point.\n\n")
  (message "Inserted \(savannah.el\)")
  )	

(defun sv-problem-uses-gnu-name ()
  (interactive)
  "There's GNU within the name of a non-GNU project"
(insert "Your project is not yet part of the GNU project, so we cannot
accept its current name.  

While there are non-GNU programs with names that include 'gnu', such
as gnuplot and gnuboy, they are not hosted on Savannah.\n We want to
maintain the distinction between GNU and non-GNU projects.

When your project is accepted into the GNU project you may change its
name.  You can do this by asking us.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-license-gplincompatible ()
  (interactive)
  "The license is incompatible with the GPL"
  (insert "
The license you chose qualifies your software as free software but
it is incompatible with the GNU GPL.

We host only software published under licenses compatible with the
GPL, which allows developers to combine files from any project without
fear of a licensing problem.

If you are willing to switch to a GPL-compatible license, please
resubmit the project.\n You can get a list of various licenses and
comments about them at
http://www.gnu.org/philosophy/license-list.html.

If you still wish to use your current license, we will be happy to
discuss it with you.\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-license-mpl-alike ()
  (interactive)
  "The license is incompatible with the GPL because it is similar to
the MPL"
  (insert " The license you chose qualifies your project as free
software but it is incompatible with the GNU GPL because it is similar
to the MPL.

MPL 1.0 is incompatible with the GNU GPL.  That is, combining a module
covered by the GPL with a module covered by the MPL is not legal.  MPL
1.1, however, allows \(section 13\) a program \(or parts of it\) to
offer a choice of another license as well.  Any part of a program that
allows the GNU GPL, or many of its variants, as an alternate choice,
is considered to have a GPL-compatible license.

We host only software published under licenses compatible with the
GPL, which allows developers to combine files from any project without
fear of a licensing problem.\n If you're willing to switch to a
GPL-compatible license, or dual license with a GPL-compatible license
and a MPL 1.1 license, please resubmit.

You can read a discussion of various licenses at
http://www.gnu.org/philosophy/license-list.html for more
information.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-open-in-name ()
  (interactive)
  "There's open within the name of a project"
  (insert "Savannah's mission is to host free software projects, and
we want the public to think of them as free software projects.  A
project name that says \"open\" will tend to lead people to think of
the project as \"open source\" instead of \"free software\".\n We
would be glad if you accept to use \"free\" instead of \"open\" in
your project name.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-gpl-two-only ()
  (interactive)
  "The user wants to use GPL2 only"
  (insert "Licensing under the \"GNU GPL v2 only\" is problematic.
Would you please agree to license under the \"GNU GPL v2 or later\"?

The reason for this is that when we publish GPL v3, it will be
important for all GPL-covered programs to advance to GPL v3.  If you
don't put this in the files now, the only way to port your program to
GPL v3 would be to ask each and every copyright holder, and that may
be very difficult.

We can explain the issue in more detail if you wish.  If you have
concerns about \"GNU GPL v2 or later\", We'd be happy to address them
too.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-linux-vs-gnu ()
  (interactive)
  "The user talks about linux instead of GNU/Linux"
  (insert "\"Linux\" is just a kernel of a more complex system
that we like to refer to as GNU/Linux, to emphasize
the ideals of the Free Software movement.\n\n
Would you mind changing references to Linux as an OS
to GNU/Linux?

For more information, see
http://www.gnu.org/gnu/linux-and-gnu.html\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-problem-gif ()
  (interactive)
  "This project uses gif files"
  (insert " Please remove GIF image files from your project and
replace them with an other format \(such as PNG or JPEG\).

Because of the patents \(Unisys and IBM\) covering the LZW
compression algorithm which are used when making GIF files,
it\'s impossible to have free software to generate proper
GIFs.  They also apply to the compress program.

For more information read http://www.gnu.org/philosophy/gif.html
\n")
  (message "Inserted \(savannah.el\)")
  )

;; REJECT

(defun sv-reject-nonfree-operating-system ()
  (interactive)
  "This project runs only on nonfree operating systems"
  (insert "Even though your project is Free Software it can not be hosted
here.  We only host projects that can run on a free operating
system (such as Debian GNU/Linux).  

We have adopted this policy because now that completely free operating
systems exist, we do not want to encourage users of those systems to
start using proprietary operating systems so that they can use your
program.

If you are willing to maintain a version for free operating systems,
which work as well as or better than other ports, you can
then provide versions for nonfree systems as well.  The idea is that at
no point should only-free users be at a disadvantage compared to users of
proprietary software.

Your project should always work equally well in free systems as in any
other version you provide; if you have some modules for nonfree
systems, you can delay their release until you have released the free
operating system version.

If you accept this commitment then please register your project again
and it should be approved in Savannah.

Thank you for your understanding.

Regards,\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-reject-proprietary ()
  (interactive)
  "This project uses proprietary software"
  (insert "
Your project requires proprietary software and cannot be
hosted on Savannah for this reason.

Savannah is willing to provide resources and time to developers
writing Free Software that can be used without the need to ask
permission from proprietary software vendor.

Thank you for your understanding.
Regards,\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-reject-java-nonfree ()
  (interactive)
  "This project uses proprietary JAVA software"
  (insert "Your project requires proprietary software and cannot be
hosted on Savannah for this reason.

Savannah is willing to provide resources and time to developers
writing Free Software that can be used without the need to ask
permission from a proprietary software vendor.

If, someday, you get free of those dependencies \(see
http://www.gnu.org/software/java for more information\), do not
hesitate to resubmit your project.

Thank you for your understanding.  

Regards,\n\n")
  (message "Inserted \(savannah.el\)")
  )

;; APPROVE

(defun sv-approve-as-nongnu ()
  (interactive)
  ""
  (insert "We have approved your project as a non-GNU project.
In order to evaluate it as a GNU package, we need more
information---a clear description of the design and
plans for the whole package, and preferably part of the code.

When those things are ready, write to maintainers@gnu.org
to ask for an evaluation of your project for inclusion in GNU.\n

Regards,
\n\n")
  (message "Inserted \(savannah.el\)")
  )


(defun sv-approve ()
  (interactive)
  ""
  (insert "Hi,

I have approved your project.  You will receive an automated e-mail
containing detailled information about the approval.

Regards,
\n\n")
  (message "Inserted \(savannah.el\)")
  )

;; CONFUSING STATEMENTS

(defun sv-confusion-commercial-and-proprietary ()
  (interactive)
  "The user talks about commercial while refering to proprietary"
  (insert "Note that commercial does not mean proprietary. 

Free Software means that users have certain freedoms; it does
not mean zero price.  \"Commercial\" means \"associated with
business\"; a commercial program may be free or non-free,
depending on its license.  So it is a mistake to treat
\"free\" and \"commercial\" as contraries.  When a business
develops free software, that is free commercial software.\n\n")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-confusion-open-and-free ()
  (interactive)
  "The user talks about open instead of free"
  (insert "Note that Savannah supports projects of the Free Software
movement, not projects of the Open Source movement.

We are careful about ethical issues and insist on producing software
that is not dependent on proprietary software.

While Open Source as defined by its founders means something pretty
close to Free Software, it's frequently misunderstood.  For more
information, read
http://www.gnu.org/philosophy/free-software-for-freedom.html\n\n")
  (message "Inserted \(savannah.el\)")
  )

;; Dead projects ?
;; manage by sv_hide_dead_projects

;; PROJECT MANAGEMENT
;; The purposes of these functions is to insert with ease commands in
;; a shell or eshell.  It should be a root shell on the server, as
;; subversions.gnu.org

(defun sv-term-project-pending-list ()
  "Inserted in a terminal, this function lists the pending projects"
  (interactive)
  (insert "mysql -e \"SELECT group_id,group_name,unix_group_name FROM groups WHERE status='P'\" savannah\n")
  (insert "for project in `mysql -Ne \"SELECT unix_group_name FROM groups WHERE status='P'\" savannah`; do grep $project /var/log/sv_register_discard* ; done")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-term-project-mark-as-deleted (project)
  "Inserted in a terminal, this function marks a project for deletion."
  (interactive (list (read-string "Project: " (current-word))))
  (insert "mysql -e \"UPDATE groups SET status='D' WHERE unix_group_name='" project "'\" savannah")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-term-project-registration-discard (project why)
  "Write a message to the log and remove completely a project from database."
  (interactive (list (read-string "Unix Group Name : " (current-word))(read-string "Why do we discard this registration: " (current-word))))
  (insert "sv_register_discard " project " --user=\"" user-mail-address "\" --comment=\"" why "\"")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-term-user-delete (user)
  "Inserted in a terminal, this function removes a user account."
  (interactive (list (read-string "User: " (current-word))))
  (insert "mysql -e \"DELETE FROM user WHERE user_name='" user "'\" savannah")
  (message "Inserted \(savannah.el\)")
  )

(defun sv-term-user-rename (user newname)
  "Inserted in a terminal, this function renames a user account."
  (interactive (list (read-string "User Name: " (current-word))(read-string "New User Name: " (current-word))))
  (insert "mysql -e \"UPDATE user SET user_name='" newname "' WHERE user_name='" user "'\" savannah")
  (message "Inserted \(savannah.el\)")
  )

(message "savannah.el loaded")
(provide 'savannah)

;; savannah.el ends here
