#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_xml.pl,v 1.8 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2001
#               Mathieu Roy <yeupou@gnu.org, 2003
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# http://sourceforge.net
#
#

use strict;
use Getopt::Long;
use Savannah;

# Import from the savannah conf
our $sys_miscdir;
our $sys_dbuser;
our $sys_dbpasswd;
our $sys_dbname;



my($prefix) = "$sys_miscdir";
my($verbose) = 0;
my($user) = "$sys_dbuser";
my($password) = "$sys_dbpasswd";
my($private) = "";
my($getopt);
my($help);
my($list);

eval {
    $getopt = GetOptions("verbose+" => \$verbose,
			 "user=s" => \$user,
			 "password=s" => \$password,
			 "private" => \$private,
			 "list" => \$list,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
usage: $0 [--user=<user> --password=<password>] [--private] 
          [--help] [--verbose] [--list]

	Generate XML dump of Savannah public information on STDOUT.

	--user=<user>		MySQL user name
	--password=<password>	MySQL password for user
	--verbose		increase verbosity level
	--private		include private information (emails, etc)
	--list			generate lists information
	--help			print this help

Author: loic\@gnu.org
EOF
 exit(1);
}

$user = "--user=$user" if($user);
$password = "--password=$password" if($password);

sub quote {
    s/&/&amp;/g; s/>/&gt;/g; s/</&lt;/g;
}

beginning();

if ($list)
{
	print " <lists>\n";
	open(LIST,"mysql $user $password -Ne \"SELECT
		user.email,mail_group_list.list_name,
		mail_group_list.password,mail_group_list.is_public,type FROM
		mail_group_list,user,groups WHERE
		mail_group_list.list_admin=user.user_id
		and groups.group_id=mail_group_list.group_id;\" $sys_dbname |") or die "mysql $user $password failed";
	while(<LIST>) {
		chop;
		quote;
		my ($admin,$name,$password,$ispublic,$isgnu) = split("\t",$_);
		next if ($password eq "pass"); #migrated list
		if ($isgnu == 1 || $isgnu == 3) {
		    $isgnu = "Y";
		} else {
		    $isgnu = "N";
		}
		print <<EOF;
  <list gnu="$isgnu">
   <admin>$admin</admin>
   <name>$name</name>
   <password>$password</password>
  </list>
EOF
	}	
	print " </lists>\n";
	end();
	exit(0);
}

print " <users>\n";

my($max_id) = 40000;

open(LIST, "mysql $user $password -Ne \"SELECT user_id,user_name,realname,email,add_date,authorized_keys,unix_pw,unix_uid FROM user WHERE status = 'A' AND ( unix_status = 'A' OR unix_status = 'N' ) AND user.user_name != 'admin'\" $sys_dbname|") or die "mysql $user $password failed";
while(<LIST>) {
    chop;
    quote;
    my($id, $user, $realname, $mail, $created, $sshpublickeys, $password, $uid) = split("\t", $_);
    if($sshpublickeys eq 'NULL') {
	$sshpublickeys = '';
    } else {
	$sshpublickeys =~ s/\#\#\#/\n/g;
	$sshpublickeys .= "\n";
    }
    $uid = $max_id++ if($uid == 0);
    print <<EOF;
  <user id='$id'>
   <login>$user</login>
   <created>$created</created>
   <realname>$realname</realname>
EOF
    if($private) {
	print <<EOF;
   <email>$mail</email>
   <password>$password</password>
   <uid>$uid</uid>
   <sshpublickeys>$sshpublickeys</sshpublickeys>
EOF
    }
    print "  </user>\n";
}
close(LIST);

print " </users>\n";

print " <projects>\n";

open(LIST, "mysql $user $password -Ne \"SELECT group_id,group_name,unix_group_name,html_cvs,http_domain FROM groups WHERE status = 'A'\" $sys_dbname|") or die "mysql $user $password failed";
while(<LIST>) {
    chop;
    quote;
    my($id, $name, $unix_name, $html_cvs, $gid) = split("\t", $_);

    if($html_cvs) {
	$html_cvs = "\n   <url>http://www.gnu.org$html_cvs</url>";
    }
    print <<EOF;
  <project id='$id'>
   <longname>$name</longname>
   <gid>$gid</gid>
   <name>$unix_name</name>$html_cvs
  </project>
EOF
}
close(LIST);

print " </projects>\n";

print " <user2projects>\n";

open(LIST, "mysql $user $password -Ne \"SELECT user.user_name, user.user_id, groups.unix_group_name, groups.group_id FROM user,user_group,groups WHERE user.user_id=user_group.user_id AND user_group.group_id=groups.group_id AND (user.unix_status = 'A' || user.unix_status = 'N') AND user.user_name != 'admin' AND groups.status = 'A'\" $sys_dbname|") or die "mysql $user $password failed";
while(<LIST>) {
    chop;
    quote;
    my($user, $user_id, $group, $group_id) = split("\t", $_);

    print <<EOF;
  <user2project user_id='$user_id' project_id='$group_id'>
   $user $group
  </user2project>
EOF
}
close(LIST);

print " </user2projects>\n";

end();

sub beginning() {
	print <<EOF;
<?xml version='1.0' encoding='ISO-8859-1' ?>
EOF
#<!DOCTYPE members SYSTEM "http://savannah.gnu.org/savannah.dtd">
print "<savannah>\n";
}

sub end() {
	print "</savannah>\n";
}
