<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: exit.php,v 1.12 2004/06/28 14:21:32 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2004      (c) ...
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.



# Generic functions

function exit_error($title,$text=0) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':exit_error($title,$text) ';
  
  global $HTML;
  global $feedback;
  
  fb($title, 1);

  $HTML->header(array('title'=>_("Exiting with Error")));
  html_feedback_top();
  
  if ($text)
    {
      print '<p>'.$text.'</p>';
    }
  $HTML->footer(array());
  exit;
}

function exit_permission_denied() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':exit_permission_denied() ';
  global $feedback;
  exit_error(_("Permission Denied"),'This project\'s administrator will have to grant you permission to view this page.');
}

function exit_not_logged_in() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':exit_not_logged_in() ';
  #instead of a simple error page, take user to the login page
  global $REQUEST_URI;
  
  if ($GLOBALS['sys_https_host'])
    {  
      header('Location: https://'.$GLOBALS['sys_https_host'].$GLOBALS['sys_home'].'account/login.php?return_to='.urlencode($REQUEST_URI));
    } 
  else 
    {
      header ("Location: http://".$GLOBALS['sys_default_domain'].$GLOBALS['sys_home']."account/login.php?return_to=".urlencode($REQUEST_URI));
    }
}

function exit_no_group() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':exit_no_group() ';
  exit_error(_("No group chosen"),'nogroup');
}

function exit_missing_param() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':exit_missing_param() ';
  exit_error(_("Missing Parameters"),'');
}

# Test per artifact

function exit_test_usesmail($group_id) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':exit_test_usesmail($group_id) ';  $project=project_get_object($group_id);
  if (!$project->usesMail()) {
    exit_error(_("Error"),_("This Project Has Turned Off Mailing Lists"));
  }
}
  

?>
