<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: help.php,v 1.11 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


# <mm> Help has to consider the sys_home, $GLOBALS['sys_home'] (it is not a relative link)

/**
* help_button() - Show a help button.
*
* @param        string    The button type
* @param        int        The trove category ID
*/
function help_button($type,$helpid) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':help_button($type,$helpid) ';	if ($type == 'trove_cat') {
		return ('<A href="javascript:help_window(\''.$GLOBALS['sys_home'].'help/trove_cat.php'
			.'?trove_cat_id='.$helpid.'\')"><B>(?)</B></A>');
	} else {
	    # Generic processing derives the script name from the help type
	    $script = $GLOBALS['sys_home'].'help/'.$type.'.php';
	    return ('<A href="javascript:help_window(\''.$script.
		    '?helpid='.$helpid.'\')"><B>(?)</B></A>');
	}
}

/**
* help_header() - Show a help page header
*
* @param        string    Header title
*/
function help_header($title, $help_banner=true) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':help_header($title, $help_banner=true) ';?>
<HTML>
<HEAD>
<TITLE><?php print $title; ?></TITLE>
<LINK rel="stylesheet" href="<?php echo $GLOBALS['sys_home'].'css/'.SV_THEME; ?>.css" type="text/css">
</HEAD>
<BODY>
<?php
# print ($help_banner ? '<H4>Savannah Site Help System</H4>' : ''); ?>
<H2><?php print $title; ?></H2>
<HR>
<?php
}

/**
* help_footer() - Show a help page footer
*/
function help_footer() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':help_footer() ';?>
</BODY>
</HTML>
<?php
}

?>
