<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: html.php,v 1.51 2004/06/26 11:50:42 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--at--gnu.org>
#
#  Copyright 2004      (c) ...
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function html_nextprev ($search_url, $rows, $rows_returned)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_nextprev ($search_url, $rows, $rows_returned) ';
  global $offset, $max_rows;

  if (($rows_returned > $rows) || ($offset != 0))
    {
      print "\n<br><h5 align=\"center\">\n";

      if ($offset != 0)
	{
	  print '<a href="'.$search_url.'&amp;offset='.($offset-$rows).'&amp;max_rows='.$max_rows.'">';
	  print '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/previous.png" border="0" alt="'._("Previous Results").'">'._("Previous Results").'</a>';

	}
      else
	{
	  print '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/previousgrey.png" border="0" alt="'._("Previous Results").'"><font class="italic">'._("Previous Results").'</font>';
	}

      print "&nbsp; &nbsp; &nbsp;";

      if ($rows_returned > $rows)
	{
	  print '<a href="'.$search_url.'&amp;offset='.($offset+$rows).'&amp;max_rows='.$max_rows.'">';
	  print _("Next Results").' <img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/next.png" border="0" alt="'._("Next Results").'"></a>';
	}
      else
	{
	  print '<font class="italic">'._("Next Results").'</font> <img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/nextgrey.png" border="0" alt="'._("Next Results").'">';
	}

      print "</h5>\n";
    }
}

function html_anchor ($content, $name) 
{
  if (!$name) { $name = $content; };
  return '<a name="'.$name.'" href="#'.$name.'">'.$content.'</a>';
}

function html_feedback_top()
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_feedback_top() ';
  if ($GLOBALS[feedback])
    {  print '<h3 class="feedback">'.htmlentities($GLOBALS[feedback]).'</h3>'; }
  if ($GLOBALS[ffeedback])
    {  print '<h3 class="feedbackerror">'.htmlentities($GLOBALS[ffeedback]).'</h3>'; }
  if ($GLOBALS[sys_debug_on] && $GLOBALS[debug])
    {  print '<h3 class="feedbackerror">DEBUG information: '.htmlentities($GLOBALS[debug]).'</h3>'; }
  # yeupou@gnu.org 2003-11-03:
  # We unset feedback so there will be a bottom feedback only if something
  # changed. It may confuse users, however I would find more confusing to
  # have to lookalike feedback information providing most of the time the
  # same information AND (that's the problem) sometimes more information
  # in the second one.
  unset($GLOBALS[feedback],$GLOBALS[ffeedback],$GLOBALS[debug]);
}

function html_feedback_bottom()
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_feedback_bottom() ';
 
 if ($GLOBALS[feedback])
    {  print '<h3 class="feedback">'.htmlentities($GLOBALS[feedback]).'</h3>'; }
  if ($GLOBALS[ffeedback])
    {  print '<h3 class="feedbackerror">'.htmlentities($GLOBALS[ffeedback]).'</h3>'; }
  if ($GLOBALS[sys_debug_on] && $GLOBALS[debug])
    {  print '<h3 class="feedbackerror">DEBUG information: '.htmlentities($GLOBALS[debug]).'</h3>'; }
}

function html_a_group($grp)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_a_group($grp) ';
  print '<A href="'.$GLOBALS['sys_home'].'project/?group_id='.$grp.'">' . group_getname($grp) . '</A>';
}

function html_blankimage($height,$width)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_blankimage($height,$width) ';
  return html_image('blank.png',array('height'=>$height,'width'=>$width,'alt'=>' '));
}

function html_image($src,$args,$display=1)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_image($src,$args,$display=1) ';
  GLOBAL $img_size;
  $return = ('<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/'.$src.'"');
  reset($args);
  while(list($k,$v) = each($args))
    {
      $return .= ' '.$k.'="'.$v.'"';
    }

  # ## insert a border tag if there isn't one
  if (!$args['border']) $return .= (' border="0"');

  # ## if no height AND no width tag, insert em both
  if (!$args['height'] && !$args['width'])
    {
      /* Check to see if we've already fetched the image data */
      if($img_size){
	if(!$img_size[$src] && is_file($GLOBALS['sys_urlroot'].'images/'.$src)){
	  $img_size[$src] = @getimagesize($GLOBALS['sys_urlroot'].'images/'.$src);
	}
      }
      else
	{
	  if(is_file($GLOBALS['sys_urlroot'].'images/'.$src)){
	    $img_size[$src] = @getimagesize($GLOBALS['sys_urlroot'].'images/'.$src);
	  }
	}
      $return .= ' ' . $img_size[$src];
    }

  # ## insert alt tag if there isn't one
  if (!$args['alt']) $return .= " alt=\"$src\"";

  $return .= ('>');
  if ($display)
    {
      print $return;
    }
  else
    {
      return $return;
    }
}

function html_get_timezone_popup ($title='timezone',$selected='xzxzxzx')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_get_timezone_popup ';
  global $TZs;
  return html_build_select_box_from_arrays ($TZs,$TZs,$title,$selected,false);
}

function html_build_list_table_top ($title_arr,$links_arr=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_list_table_top ';
  /*
		Takes an array of titles and builds
		The first row of a new table

		Optionally takes a second array of links for the titles
  */
  GLOBAL $HTML;

  $return = '
	<table class="box">
		<tr>';

  $count=count($title_arr);
  if ($links_arr)
    {
      for ($i=0; $i<$count; $i++)
	{
	  $return .= '
			<td class="boxtitle"><a class=sortbutton href="'.$links_arr[$i].'">'.$title_arr[$i].'</a></td>';
	}
    }
  else
    {
      for ($i=0; $i<$count; $i++)
	{
	  $return .= '
			<td class="boxtitle">'.$title_arr[$i].'</td>';
	}
    }
  return $return.'</tr>';
}

function html_get_alt_row_color ($i)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_get_alt_row_color ($i) ';
  GLOBAL $HTML;
  if ($i % 2 == 0)
    {
      return 'boxitemalt';
    }
  else
    {
      return 'boxitem';
    }
}

#deprecated
function utils_get_alt_row_color ($i)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':utils_get_alt_row_color ($i) ';
  return html_get_alt_row_color ($i);
}


function html_build_select_box_from_array ($vals,$select_name,$checked_val='xzxz',$samevals = 0)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_select_box_from_array ';
  /*
		Takes one array, with the first array being the "id" or value
		and the array being the text you want displayed

		The second parameter is the name you want assigned to this form element

		The third parameter is optional. Pass the value of the item that should be checked
  */

  $return .= '
		<select name="'.$select_name.'">';

  $rows=count($vals);

  for ($i=0; $i<$rows; $i++)
    {
      if ( $samevals )
	{
	  $return .= "\n\t\t<option value=\"" . $vals[$i] . "\"";
	  if ($vals[$i] == $checked_val)
	    {
	      $return .= ' selected';
	    }
	}
      else
	{
	  $return .= "\n\t\t<option value=\"" . $i .'"';
	  if ($i == $checked_val)
	    {
	      $return .= ' selected';
	    }
	}
      $return .= '>'.$vals[$i].'</option>';
    }
  $return .= '
		</select>';

  return $return;
}

function html_build_select_box_from_arrays ($vals,$texts,$select_name,$checked_val='xzxz',$show_100=true,$text_100='None', $show_any=false,$text_any='Any')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_select_box_from_arrays ';
  /*

  The infamous '100 row' has to do with the
			SQL Table joins done throughout all this code.
		There must be a related row in users, categories, etc, and by default that
			row is 100, so almost every pop-up box has 100 as the default
		Most tables in the database should therefore have a row with an id of 100 in it
			so that joins are successful

		There is now another infamous row called the Any row. It is not
		in any table as opposed to 100. it's just here as a convenience mostly
		when using select boxes in queries (bug, task,...). The 0 value is reserved
		for Any and must not be used in any table.

		Params:

		Takes two arrays, with the first array being the "id" or value
		and the other array being the text you want displayed

		The third parameter is the name you want assigned to this form element

		The fourth parameter is optional. Pass the value of the item that should be checked

		The fifth parameter is an optional boolean - whether or not to show the '100 row'

		The sixth parameter is optional - what to call the '100 row' defaults to none
		The 7th parameter is an optional boolean - whether or not to show the 'Any row'

		The 8th parameter is optional - what to call the 'Any row' defaults to nAny	*/

  $return .= '
		<SELECT NAME="'.$select_name.'">';


  #we don't always want the default any  row shown
  if ($show_any)
    {
      $selected = ( $checked_val == 0 ? 'SELECTED':'');
      $return .= "\n<OPTION VALUE=\"0\" $selected>$text_any </OPTION>";
    }

  #we don't always want the default 100 row shown
  if ($show_100)
    {
      $selected = ( $checked_val == 100 ? 'SELECTED':'');
      $return .= "\n<OPTION VALUE=\"100\" $selected>$text_100 </OPTION>";
    }

  $rows=count($vals);
  if (count($texts) != $rows)
    {
      $return .= 'ERROR - uneven row counts';
    }

  for ($i=0; $i<$rows; $i++)
    {
      #  uggh - sorry - don't show the 100 row and Any row
      #  if it was shown above, otherwise do show it
      if ( (($vals[$i] != '100') && ($vals[$i] != '0')) ||
	   ($vals[$i] == '100' && !$show_100) ||
	   ($vals[$i] == '0' && !$show_any) )
	{
	  $return .= '
				<OPTION VALUE="'.$vals[$i].'"';
	  if ($vals[$i] == $checked_val)
	    {
	      $return .= ' SELECTED';
	    }
	  $return .= '>'.$texts[$i].'</OPTION>';
	}

    }
  $return .= '
		</SELECT>';
  return $return;
}

function html_build_select_box ($result, $name, $checked_val="xzxz",$show_100=true,$text_100='None',$show_any=false,$text_any='Any')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_select_box  ';
  /*
		Takes a result set, with the first column being the "id" or value
		and the second column being the text you want displayed

		The second parameter is the name you want assigned to this form element

		The third parameter is optional. Pass the value of the item that should be checked

		The fourth parameter is an optional boolean - whether or not to show the '100 row'

		The fifth parameter is optional - what to call the '100 row' defaults to none
  */

  return html_build_select_box_from_arrays (utils_result_column_to_array($result,0),utils_result_column_to_array($result,1),$name,$checked_val,$show_100,$text_100,$show_any,$text_any);
}

function html_build_multiple_select_box ($result,$name,$checked_array,$size='8',$show_100=true,$text_100='None', $show_any=false,$text_any='Any',$show_value=true)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_multiple_select_box ';
  /*
		Takes a result set, with the first column being the "id" or value
		and the second column being the text you want displayed

		The second parameter is the name you want assigned to this form element

		The third parameter is an array of checked values;

		The fourth parameter is optional. Pass the size of this box

		Fifth to eigth params determine whether to show None and Any

		Ninth param determine whether to show numeric values next to
		the menu label (default true for backward compatibility
  */

  $checked_count=count($checked_array);
  #      print '-- '.$checked_count.' --';
  $return .= '
		<SELECT NAME="'.$name.'" MULTIPLE SIZE="'.$size.'">';
  /*
		Put in the Any box
  */
  if ($show_any)
    {
      $return .= '
		<OPTION VALUE="0"';
      for ($j=0; $j<$checked_count; $j++)
	{
	  if ($checked_array[$j] == '0')
	    {
	      $return .= ' SELECTED';
	    }
	}
      $return .= '>'.$text_any.'</OPTION>';
    }

  /*
		Put in the default NONE box
  */
  if ($show_100)
    {
      $return .= '
		<OPTION VALUE="100"';
      for ($j=0; $j<$checked_count; $j++)
	{
	  if ($checked_array[$j] == '100')
	    {
	      $return .= ' SELECTED';
	    }
	}
      $return .= '>'.$text_100.'</OPTION>';
    }

  $rows=db_numrows($result);

  for ($i=0; $i<$rows; $i++)
    {
      if (db_result($result,$i,0) != '100')
	{
	  $return .= '
				<OPTION VALUE="'.db_result($result,$i,0).'"';
	  /*
				Determine if it's checked
	  */
	  $val=db_result($result,$i,0);
	  for ($j=0; $j<$checked_count; $j++)
	    {
	      if ($val == $checked_array[$j])
		{
		  $return .= ' SELECTED';
		}
	    }
	  $return .= '>'. ($show_value?$val.'-':'').
	     substr(db_result($result,$i,1),0,35). '</OPTION>';
	}
    }
  $return .= '
		</SELECT>';
  return $return;
}

function html_select_permission_box ($artifact, $row, $level="member")
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_select_permission_box ($artifact, $row, $level="member")';
  # If $row['user_id'] does not exists, we havent got a row but simple value
  # and it means that we are about to modify per group default
  if ($level == "type")
    {
      $value = $row;
      $default = 0;
    }
  elseif ($level == "group")
    {
      $value = $row;
      $default = _("Group Type Default");
    }
  else
    {
      $num = $row['user_id'];
      $value = $row[$artifact.'_flags'];
      $default = _("Group Default");
    }

  print '
    <td>
      <select name="'.$artifact.'_user_'.$num.'">';
  if ($default)
    {
      print '
        <option value="NULL"'.((!$value)?" selected":"").'>'.$default.'</option>';
    }
  print '
        <option value="9"'.(($value == 9)?" selected":"").'>'._("None").'</option>';
  if ($artifact != "news")
    {
      print '
        <option value="1"'.(($value == 1)?" selected":"").'>'._("Technician").'</option>';
    }

  print '
        <option value="3"'.(($value == 3)?" selected":"").'>'._("Manager").'</option>';


  if ($artifact != "news")
    {
      print '
        <option value="2"'.(($value == 2)?" selected":"").'>'._("Techn. & Manager").'</option>';
    }

  print '
      </select>';

  if (!$value && $level == "group")
    {
      $value = group_gettypepermissions($GLOBALS[group_id], $artifact);
      print '<br>('.
	(($value == 9)?_("None"):"").
	(($value == 1)?_("Technician"):"").
	(($value == 3)?_("Manager"):"").
	(($value == 2)?_("Techn. & Manager"):"").
	')';
    }
  print '
    </td>';
}

# This function must now every type of directory that can be built by the
# backend.
# FIXME: in a future, we may create a table of method associating
# method -> perl module -> sub name
function html_select_typedir_box ($input_name, $current_value)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_select_typedir_box ';
  print '<br>
      <select name="'.$input_name.'">
        <option value="basiccvs"'.(($current_value == "basiccvs")?" selected":"").'>'._("Basic Cvs Directory").'</option>
        <option value="basicdirectory"'.(($current_value == "basicdirectory")?" selected":"").'>'._("Basic Directory").'</option>
        <option value="cvsattic"'.(($current_value == "cvsattic")?" selected":"").'>'._("Cvs Attic").'</option>
      </select> [BACKEND SPECIFIC]
';

  # put some information
  print '<br><font class="italic">Basic directory will make the backend using DownloadMakeArea(), defined in Savannah::Download; <br> CVS directory will make the backend using CvsMakeArea(), defined in Savannah::Cvs;<br>
(If you need to build directories with another method, the solution is to write a new sub in the appropriate perl module, please send a mail to savannah-dev@gnu.org to get information about that)</font><br>';

}

# Print an theme select box. This function will add the special rotate
# and random meta-themes. This function will hide disallowed theme.
# That is said that theme are not strictly forbidden, someone can
# forge a form and choose a forbidden theme.
# But it is really not a big deal and it is better to have making to
# many checks in theme_list(), which is frequently ran, unlike this
# one.
function html_select_theme_box ($input_name="user_theme", $current=0)
{

  print  '
		<select name="'.$input_name.'">';

  # usual themes
  $data = theme_list(1);
  while (list(,$theme) = each($data))
    {
      print "\n\t\t".'<option value="'.$theme.'"';
      if ($theme == $current)
	{ print ' selected'; }
      print '>'.$theme;
      if ($theme == $GLOBALS['sys_themedefault'])
	{ print ' ('._("default").')'; }
      print '</option>'."\n";
    }

  # special rotate case
  $theme = "rotate";
  print "\n\t\t".'<option value="'.$theme.'"';
  if ($theme == $current)
    { print ' selected'; }
  print '>'.$theme.' ('.("a different theme alphabetically picked everyday").')</option>';
  # special random case
  $theme = "random";
  print "\n\t\t".'<option value="'.$theme.'"';
  if ($theme == $current)
    { print ' selected'; }
  print '>'.$theme.' ('.("a different theme randomly picked everyday").')</option>';
  print "		</select>\n";

}

function html_build_priority_select_box ($name='priority', $checked_val='5')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_priority_select_box ';
  /*
		Return a select box of standard priorities.
		The name of this select box is optional and so is the default checked value
  */
    ?>
     <SELECT NAME="<?php print $name; ?>">
	<OPTION VALUE="1"<?php if ($checked_val=="1")
	  {print " SELECTED";} ?>>1 - Lowest</OPTION>
				    <OPTION VALUE="2"<?php if ($checked_val=="2")
				      {print " SELECTED";} ?>>2</OPTION>
								<OPTION VALUE="3"<?php if ($checked_val=="3")
								  {print " SELECTED";} ?>>3</OPTION>
											    <OPTION VALUE="4"<?php if ($checked_val=="4")
											      {print " SELECTED";} ?>>4</OPTION>
															<OPTION VALUE="5"<?php if ($checked_val=="5")
															  {print " SELECTED";} ?>>5 - Medium</OPTION>
																		    <OPTION VALUE="6"<?php if ($checked_val=="6")
																		      {print " SELECTED";} ?>>6</OPTION>
																						<OPTION VALUE="7"<?php if ($checked_val=="7")
																						  {print " SELECTED";} ?>>7</OPTION>
																									    <OPTION VALUE="8"<?php if ($checked_val=="8")
																									      {print " SELECTED";} ?>>8</OPTION>
																													<OPTION VALUE="9"<?php if ($checked_val=="9")
																													  {print " SELECTED";} ?>>9 - Highest</OPTION>
																																    </SELECT>
																																    <?php

																																    }
function html_buildpriority_select_box ($name='priority', $checked_val='5')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_buildpriority_select_box  ';
  return html_build_priority_select_box($name, $checked_val);
}


function html_build_checkboxarray($options,$name,$checked_array)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_checkboxarray ';
  $option_count=count($options);
  $checked_count=count($checked_array);

  for ($i=1; $i<=$option_count; $i++)
    {
      print '
			<BR><INPUT type="checkbox" name="'.$name.'" value="'.$i.'"';
      for ($j=0; $j<$checked_count; $j++)
	{
	  if ($i == $checked_array[$j])
	    {
	      print ' CHECKED';
	    }
	}
      print '> '.$options[$i];
    }
}

function html_buildcheckboxarray($options,$name,$checked_array)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_buildcheckboxarray ';
  #deprecated
  return html_build_checkboxarray($options,$name,$checked_array);
}

function html_build_checkbox ($name, $is_checked=0)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_build_checkbox ($name, $is_checked=0)';
  print  '<input type="checkbox" name="'.$name.'" value="1"';
  if ($is_checked)
    { print ' checked'; }
  print '>';
}

/*!     @function site_user_header
        @abstract everything required to handle security and
                add navigation for user pages like /my/ and /account/
        @param params array() must contain $user_id
        @result text - prints HTML to the screen directly
*/
function site_header($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_header($params) ';
  global $HTML;
  print $HTML->header($params);
  print html_feedback_top($GLOBALS['feedback']);
  print $HTML->site_tabs($params);
}

function site_footer($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_footer($params) ';
  global $HTML;
  print html_feedback_bottom($GLOBALS['feedback']);
  $HTML->footer($params);
}

/*
	Project pages functions
	----------------------------------------------------------------
*/


/*! 	@function site_project_header
	@abstract everything required to handle security and state checks for a project web page
	@param params array() must contain $toptab and $group
	@result text - prints HTML to the screen directly
*/
function site_project_header($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_project_header($params) ';
  global $HTML;

  /*
		Check to see if active
		Check to see if project rather than foundry
		Check to see if private (if private check if user_ismember)
  */

  $group_id=$params['group'];

  #get the project object
  $project=project_get_object($group_id);

  #group doesn't exist
  if ($project->isError())
    {
      exit_error("Invalid Group $group_id","That group does not exist.");
    }

  #group is private
  if (!$project->isPublic())
    {
      #if its a private group, you must be a member of that group
      session_require(array('group'=>$group_id));
    }

  #for dead projects must be member of admin project
  if (!$project->isActive())
    {
      # only sys_group people can view non-active, non-holding groups
      session_require(array('group'=>$GLOBALS['sys_group_id']));
    }

  print $HTML->header($params);
  print html_feedback_top($GLOBALS['feedback']);
  print $HTML->project_tabs($params);
}

/*!     @function site_project_footer
	@abstract currently a simple shim that should be on every project page,
		rather than a direct call to site_footer() or theme_footer()
	@param params array() empty
	@result text - prints HTML to the screen directly
*/
function site_project_footer($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_project_footer($params) ';
  global $HTML;
  print html_feedback_bottom($GLOBALS['feedback']);
  print $HTML->footer($params);
}

/*
	User pages functions
	----------------------------------------------------------------
*/

/*!     @function site_user_header
	@abstract everything required to handle security and
		add navigation for user pages like /my/ and /account/
	@param params array() must contain $user_id
	@result text - prints HTML to the screen directly
*/
function site_user_header($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_user_header($params) ';
  global $HTML;

  /*
		Check to see if active user
		Check to see if logged in
  */

  session_require(array('isloggedin'=>'1'));

  print $HTML->header($params);
  print html_feedback_top($GLOBALS['feedback']);
  print $HTML->user_tabs($params);
}

/*!     @function site_user_footer
	@abstract currently a simple shim that should be on every user page,
		rather than a direct call to site_footer() or theme_footer()
	@param params array() empty
	@result text - prints HTML to the screen directly
*/
function site_user_footer($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_user_footer($params) ';
  global $HTML;
  html_feedback_bottom($GLOBALS['feedback']);
  print $HTML->footer($params);
}

/*
	Administrative pages functions
	----------------------------------------------------------------
*/

function site_admin_header($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_admin_header($params) ';
  global $HTML,$feedback;

  session_require(array('group'=>'1','admin_flags'=>'A'));

  $HTML->header($params);
  print html_feedback_top($feedback);
  $HTML->admin_tabs($params);
}

function site_admin_footer($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':site_admin_footer($params) ';
  global $HTML,$feedback;
  html_feedback_bottom($feedback);
  $HTML->footer($params);
}

function show_group_type_box($name='group_type',$checked_val='xzxz')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_group_type_box ';
  $result=db_query("SELECT * FROM group_type");
  return html_build_select_box ($result,'group_type',$checked_val,false);
}


function html_member_explain_roles ()
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':html_member_explain_roles ';

  print _("Technicians, and only technicians, can be assigned tracker's items. They cannot reassign items, change the status or priority of items.");
  print '<p>';
  print _("Trackers Managers can fully manage the trackers items, including assigning items to technicians, reassign items over trackers and projects, changing priority and status of items - but they cannot configure the trackers.");
  print '<p>';
  print _("Project Admins can manage members, configure the trackers, post jobs, and add mailing-list. They actually also have both technician and manager rights on every tracker.");
  print '<p>';
}

?>
