<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: category.php,v 1.5 2004/08/23 13:28:42 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2004      (c) ...
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function people_get_category_name($category_id) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_get_category_name($category_id) ';
  $sql="SELECT name FROM people_job_category WHERE category_id='$category_id'";
  $result=db_query($sql);
  if (!$result || db_numrows($result) < 1) 
    {
      return 'Invalid ID';
    } 
  else 
    {
      return db_result($result,0,'name');
    }
}

function people_show_category_table() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_show_category_table() ';

  #show a list of categories in a table
  #provide links to drill into a detail page that shows these categories

  $title_arr=array();
  $title_arr[]=_("Category");

  $return .= html_build_list_table_top ($title_arr);

  $sql="SELECT * FROM people_job_category ORDER BY category_id";
  $result=db_query($sql);
  $rows=db_numrows($result);
  if (!$result || $rows < 1) 
    {
      $return .= '<tr><td><h2>'._("No Categories Found").'</h2></td></tr>';
    } 
  else 
    {
      for ($i=0; $i<$rows; $i++) 
	{
	  $count_res=db_query("SELECT count(*) AS count FROM people_job WHERE category_id='". db_result($result,$i,'category_id') ."' AND status_id='1'");
	  echo db_error();
	  $return .= '<tr class="'. utils_get_alt_row_color($i) .'"><td><a href="'.$GLOBALS['sys_home'].'people/?category_id='. 
	     db_result($result,$i,'category_id') .'">'. 
	     db_result($result,$i,'name') .'</a> ('. db_result($count_res,0,'count') .')</td></tr>';
	}
    }
  $return .= '</table>';
  return $return;
}

function people_show_category_list() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_show_category_list() ';

  #show a list of categories 
  #provide links to drill into a detail page that shows these categories

  $sql="SELECT * FROM people_job_category ORDER BY category_id";
  $result=db_query($sql);
  $rows=db_numrows($result);
  if (!$result || $rows < 1) 
    {    $return .= _("No Categories Found");
    } 
  else 
    {
      for ($i=0; $i<$rows; $i++) 
	{
	  $count_res=db_query("SELECT count(*) AS count FROM people_job WHERE category_id='". db_result($result,$i,'category_id') ."' AND status_id='1'");
	  echo db_error();
	  # Print only if there are result within the category
	  if (db_result($count_res,0,'count') > 0) 
	    {
	      $return .= '&nbsp;&nbsp;- <a href="'.$GLOBALS['sys_home'].'people/?category_id='. 
		db_result($result,$i,'category_id') .'">'.db_result($count_res,0,'count'). 
		' '.db_result($result,$i,'name') .'</a><br>';
	    }
	}
    }
  return $return;
}


function people_show_category_jobs($category_id) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_show_category_jobs($category_id) ';
  #show open jobs for this category
  $sql="SELECT people_job.group_id,people_job.job_id,groups.unix_group_name,groups.group_name,groups.type,people_job.title,people_job.date,people_job_category.name AS category_name ".
     "FROM people_job,people_job_category,groups ".
     "WHERE people_job.category_id='$category_id' ".
     "AND people_job.group_id=groups.group_id ".
     "AND groups.is_public = 1 ".
     "AND people_job.category_id=people_job_category.category_id ".
     "AND people_job.status_id=1 ORDER BY date DESC";
  $result=db_query($sql);

  return people_show_job_list($result);
}


?>
