<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: general.php,v 1.8 2004/06/28 14:21:32 yeupou Exp $
#
#  Copyright 2003-2004 (c) Stphane Urbanovski <s.urbanovski@ac-nancy-metz.fr>
#                          Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function search_box ($searched_words='', $only_artifact=0, $size=15)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':search_box ';
  global $words,$forum_id,$group_id,$is_bug_page,$exact,$type_of_search,$type,$max_rows,$printer;

  # if there is no search currently, set the default
  if (!isset($type_of_search))
    { $exact = 1; }
  if (!isset($max_rows))
    { $max_rows = "25"; }


  # if the wildcard '%%%' is searched, replace it with the more usual '*'
  if ($words == "%%%")
    { $words = "*"; }

  print '<form action="'.$GLOBALS['sys_home'].'search/" method="get" >';
  print '<input type="text" size="'.$size.'" name="words" value="'.$searched_words.'">';

  if ($size < 16)
    { print '<br>'; }

  if ($only_artifact)
    {
      print '<input type="hidden" name="type_of_search" value="'.$only_artifact.'">';
    }
  else
    {
      print ' '._("in").' <select name="type_of_search">';

      print '<option value="soft"'.(($type_of_search == "soft")||($type_of_search == "") ? " selected" : "").'>'._("Project/Group")."</option>\n";

      print '<option value="people"'.(($type_of_search == "people") ? " selected" : "").'>'._("People")."</option>\n";

      print '<option value="support"'.(($type_of_search == "support") ? " selected" : "").'>'._("Support")."</option>\n";

      print '<option value="bugs"'.(($type_of_search == "bugs") ? " selected" : "").'>'._("Bugs")."</option>\n";

      print '<option value="task"'.(($type_of_search == "task") ? " selected" : "").'>'._("Task")."</option>\n";

      print '<option value="patch"'.(($type_of_search == "patch") ? " selected" : "").'>'._("Patch")."</option>\n";

      if ($GLOBALS['sys_use_google'])
	{
	  print '<option value="google"'.(($type_of_search == "google") ? " selected" : "").' class="italic">'._("via Google")."</option>\n";
	}

      print '</select>';

    }
  if ($size < 16)
    { print '<br>'; }

  if (isset($group_id))
    {
      print "<input type=\"hidden\" value=\"$group_id\" name=\"group_id\">\n";
    }
  if (isset($printer))
    {
      print "<input type=\"hidden\" value=\"1\" name=\"printer\">\n";
    }

  print ' <input type="submit" name="Search" value="'._("Search").'">';

  if ($size > 15)
    {
      print '<br />&nbsp;<input type="radio" name="exact" value="0"'.( $exact ? " " : " checked").'>'._("with at least one of the words")."\n";
      print '<br />&nbsp;<input type="radio" name="exact" value="1"'.( $exact ? " checked" : " " ).'>'._("with all of the words")."\n";
      print '<br />&nbsp;'.sprintf(_("%s results per page"), '<input type="text" name="max_rows" value="'.$max_rows.'" size="4">')."\n";

      # add the functionality to restrict the search to a project type
      print "<br />&nbsp;";
      
      $select = '<select name="type" size="1"><option value="">'._("any").'</option>'."\n";
      $result = db_query("SELECT type_id,name FROM group_type ORDER BY type_id");
      while ($eachtype = db_fetch_array($result))
        {
          $select .= '<option value="'.$eachtype['type_id'].'"'.($type == $eachtype['type_id'] ? ' selected="selected"' : '').'>'.$eachtype['name'].'</option>'."\n";
        }
      $select .= '</select>'."\n";

      print sprintf(_("Search in %s group type, when searching for a \"Project/Group\"."), $select);

      print '<p>'._("Note: You can use the wildcard *, standing for everything.").'</p>';
    }
  else
    {
      print '<input type="hidden" name="exact" value="1">';
    }

  print '</form>';
}

function search_send_header ()
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':search_send_header () ';
  global $HTML,$words,$type_of_search,$group_id,$printer;

  if ($type_of_search == "soft" || $type_of_search == "people")
    {
      # there cannot be a group id specific if we are looking for a group
      # group id is meaningless when looking for someone
      $group_id = 0;
    }

  if (!$printer)
    { site_header(array('title'=>_("Search"),'toptab'=>'search')); }
  else
    {

      print '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/REC-html40/loose.dtd">

<html>
  <head>
    <title>'._("Search").'</title>
    <meta name="Generator" content="Savane, see http://gna.org/" />
    <link rel="stylesheet" type="text/css" href="'.$GLOBALS['sys_home'].'css/'.SV_THEME.'.css">
    <link rel="icon" type="image/png" href="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/icon.png">';

    }
  # Print the form
  print '<h3>';
  if (!$group_id)
    { print _("New search:"); }
  else
    { printf(_("New search for the Group %s:"), group_getname($group_id)); }
  print '</h3>';
  print "<div>";
  search_box($words, '', 45);
  print '</div>';

  print '<br>';
  # Print the result
  print '<h3>';
  if ($words && $type_of_search)
    {
      # Print real words describing the type of search
      if ($type_of_search == "soft")
	{ $type_of_search_real = _("Project/Group"); }
      else if ($type_of_search == "support")
	{ $type_of_search_real = _("Support"); }
      else if ($type_of_search == "bugs")
	{ $type_of_search_real = _("Bugs"); }
      else if ($type_of_search == "task")
	{ $type_of_search_real = _("Task"); }
      else if ($type_of_search == "patch")
	{ $type_of_search_real = _("Patch"); }
      else if ($type_of_search == "people")
	{ $type_of_search_real = _("People"); }

      if (!$group_id)
	{
	  printf(_("Search results for %s (in %s):"), '<font class="bold">'.$words.'</font>', $type_of_search_real);
	}
      else
	{
	  printf(_("Search results for %s (in %s, for the Group %s):"), '<font class="bold">'.$words.'</font>', $type_of_search_real, group_getname($group_id));
	}
    }
  else
    { print _("Search results:"); }

  print '</h3>';


  if (!$printer)
    {
      print '<p><a href="'.$GLOBALS['REQUEST_URI'].'&amp;printer=1"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/print.png" border="0">'._('Printer version').'</a></p>';
    }
}


function result_no_match ()
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':result_no_match () '; return search_failed();
}

function search_failed ()
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':search_failed () ';
  global $no_rows,$words;
  $no_rows = 1 ;
  search_send_header();
  print '<font class="warn">';
  print _("None found. Please note that only search words of more than three characters are valid.");
  print '</font>';
  print db_error();
}

# Run a search in the database, by default on softwares
function search_run ($words, $type_of_search="soft", $return_error_messages=1)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':search_run ($words, $type_of_search="soft", $return_error_messages=1) ';
  global $type, $exact, $crit, $offset, $group_id, $search_without_group_id, $max_rows;

  # Remove useless blank spaces, escape nasty characters
  $words = trim($words);
  $words = addslashes($words);

  # Convert the wildcard * to the similar SQL one, when it is alone
  if ($words == "*")
    { $words = "%%%"; }

  # Replace the wildcard * to the similar SQL one, when included in a
  # word
  $words = strtr($words, "*", "%");

  # Convert the crit form value to the SQL equiv.
  if ($exact)
    { $crit='AND'; }
  else
    { $crit='OR'; }

  # No offset defined? Start the search in the db at 0
  if (!$offset || $offset < 0)
    { $GLOBALS['offset'] = 0; }

  # No how many rows to print? Print 25 rows by default
  if (!$max_rows)
    { $GLOBALS['max_rows'] = 25; }

  # Accept only to do a search for more than 2 characters.
  # Exit only if we were not told to avoid returning error messages.
  if ($words && (strlen($words) < 3) && $return_error_messages)
    {
      search_failed();
      exit;
    }

  # Build arrays
  $array = explode(" ", $words);
  if ($type_of_search == "soft")
    {
      $words1 = implode($array,"%' $crit group_name LIKE '%");
      $words2 = implode($array,"%' $crit short_description LIKE '%");
      $words3 = implode($array,"%' $crit unix_group_name LIKE '%");
    }
  else if ($type_of_search == "people")
    {
      $words1=implode($array,"%' $crit user_name LIKE '%");
      $words2=implode($array,"%' $crit realname LIKE '%");
    }
  else if ($type_of_search == 'bugs' ||
	   $type_of_search == 'support' ||
	   $type_of_search == 'patch' ||
	   $type_of_search == 'task')
    {
      $words1=implode($array,"%' $crit ".$type_of_search.".details LIKE '%");
      $words2=implode($array,"%' $crit ".$type_of_search.".summary LIKE '%");
    }

  # Build SQL command
  if ($type_of_search == "soft")
    {
      if (!$type)
	{
	  $sql = "SELECT group_name,unix_group_name,type,group_id,short_description ".
	     "FROM groups ".
	     "WHERE status='A' AND is_public='1' ".
	     "AND ((group_name LIKE '%$words1%') OR (short_description LIKE '%$words2%') OR (unix_group_name LIKE '%$words3%')) ORDER BY  unix_group_name,group_name LIMIT $offset,".($max_rows+1);
	}
      else
	{
	  $sql = "SELECT group_name,unix_group_name,type,group_id,short_description ".
	     "FROM groups ".
	     "WHERE status='A' AND type='$type' AND is_public='1' ".
	     "AND ((group_name LIKE '%$words1%') OR (short_description LIKE '%$words2%') OR (unix_group_name LIKE '%$words3%')) ORDER BY unix_group_name,group_name LIMIT $offset,".($max_rows+1);
	}
    }
  else if ($type_of_search == "people")
    {
      $sql = "SELECT user_name,user_id,realname "
	 . "FROM user "
	 . "WHERE ((user_name LIKE '%$words1%') OR (realname LIKE '%$words2%')) AND (status='A') ORDER BY user_name LIMIT $offset,".($max_rows+1);
    }
  else if ($type_of_search == 'bugs' ||
	   $type_of_search == 'support' ||
	   $type_of_search == 'patch' ||
	   $type_of_search == 'task')
    {

      if ($group_id && !$search_without_group_id)
	{
	  # $search_without_group_id can be set to avoid restricting search
	  # to a group even if group_id is set
	  $sql_with_group_id = "AND ".$type_of_search.".group_id='$group_id' ";
	}

      $sql = "SELECT ".$type_of_search.".bug_id,".
	 $type_of_search.".summary,".
	 $type_of_search.".date,".
	 $type_of_search.".privacy,".
	 $type_of_search.".submitted_by,".
	 "user.user_name,".
	 $type_of_search.".group_id "
	 . "FROM ".$type_of_search.",user "
	 . "WHERE user.user_id=".$type_of_search.".submitted_by AND ((".$type_of_search.".details LIKE '%$words1%') "
	 . "OR (".$type_of_search.".summary LIKE '%$words2%')) "
	 . $sql_with_group_id
	 . "GROUP BY bug_id,summary,date,user_name "
	 . "ORDER BY ".$type_of_search.".date DESC "
	 . "LIMIT $offset,".($max_rows+1);
    }

  return db_query($sql);
}

?>
