<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.84 2004/09/22 08:11:50 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../include/pre.php";

if (!$group_id)
{
  exit_no_group();
}

if (!$project->Uses("cvs") && !$project->Uses("homepage"))
{
  exit_error(_("Error"),_("This project has turned off CVS"));
}

site_project_header(array('group'=>$group_id,'toptab'=>'cvs'));


# ####################### CVS Browsing

if ($project->isPublic())
{

  print '<h2>'._("Browsing the CVS Repository").'</h2>';
  print '<p>'._("You can Browse the CVS tree of this project with your web browser").'. ';
  print _("This gives you a good picture of the current status of the source files").'. ';
  print _("You may also view the complete histories of any file in the repository as well as differences among two versions").'.</p>';

  print '<h3>'._("You can browse:").'</h3>';
  print '<ul>';

  if ($project->getUrl("cvs_viewcvs") != 'http://' &&
      $project->getUrl("cvs_viewcvs") != '')
    {
      print '<li><a href="'.$project->getUrl("cvs_viewcvs").'">'._("CVS Repository (Software)").'</a></li>';
    }
  if ($project->getUrl("cvs_viewcvs_homepage") != 'http://' &&
      $project->getUrl("cvs_viewcvs_homepage") != '' &&
      $project->Uses("homepage"))
    {
      # Consider that this link is valid if not empty or not '/' (default).
      # Only the backend should make use of the is_homepage_on_cvs value,
      # because and homepage can be on CVS with this flag off: this flag
      # is used to determine whether a CVSROOT must be created or not
      print '<li><a href="'.$project->getUrl("cvs_viewcvs_homepage").'">'._("CVS Repository (Web Pages)").'</a></li>';
    }
  print '</ul>';

}
else
{
  print '<h2>'._("Existing CVS Repositories").'</h2>';
  if ($project->CanUse("cvs"))
    {
      print '<p>'._("CVS Repository (Software)").'</p>';
    }
  if ($project->CanUse("homepage"))
    {
      print '<p>'._("CVS Repository (Web Pages)").'</p>';
    }
}


# ####################### HOW TO CHECK OUT MODULES

if ($project->isPublic())
{

  # ####################### Basic help
  # ####################### CVS Modules

  utils_get_content("cvs/index_help");

  # ####################### Anonymous access

  utils_get_content("cvs/index_anoncvs");

}

# ####################### Ssh developer access

utils_get_content("cvs/index_dev");


# ####################### Kerberos dev access

if ($GLOBALS['sys_use_krb5'] != "no")
{
  # we get site-specific content
  utils_get_content("cvs/index_krb");

}

# ####################### Info about symlinks for homepage

if ($project->CanUse("homepage"))
{
  utils_get_content("cvs/index_symlinks");
}

# ####################### More informations

utils_get_content("cvs/index_more_info");

# ####################### Help!

print '<h3 class="error">'._("Need Help?").'</h3>';
print '<p>'.sprintf(_("You may take a look at the %sSavane FAQ%s:") ,'<a href="'.$GLOBALS['sys_home'].'faq/?group='.$GLOBALS['sys_unix_group_name'].'">', '</a>');
if ($project->CanUse("cvs"))
{
  print '<br /><a href="'.$GLOBALS['sys_home'].'faq/?group='.$GLOBALS['sys_unix_group_name'].'&amp;question=How_do_I_import_my_project_into_the_CVS.txt">'._("How do I import my project into the CVS (Sources)").' ?</a>';
}
if ($project->CanUse("homepage"))
{
  print '<br /><a href="'.$GLOBALS['sys_home'].'faq/?group='.$GLOBALS['sys_unix_group_name'].'&amp:question=How_do_I_upload_my_homepage_(CVS_HTML).txt">'._("How do I upload my homepage (CVS HTML)").' ?</a>';
}
print '</p>';


site_project_footer(array());


?>
